/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.jcr.util.NodeUtil;
import info.magnolia.jcr.util.PropertyUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.TaskExecutionException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.commons.predicate.Predicate;

public class NodeSortTask
extends AbstractRepositoryTask {
    private String repository;
    private String node;
    private String property;

    public NodeSortTask(String repository, String node, String property) {
        super("Reorder " + node, "Reorder " + node);
        this.repository = repository;
        this.node = node;
        this.property = property;
    }

    public NodeSortTask(String repository, String node) {
        this(repository, node, null);
    }

    protected void doExecute(InstallContext ctx) throws RepositoryException, TaskExecutionException {
        Session session = ctx.getJCRSession(this.repository);
        Node parent = session.getNode(this.node);
        List children = NodeUtil.asList((Iterable)NodeUtil.getNodes((Node)parent, (Predicate)NodeUtil.EXCLUDE_META_DATA_FILTER));
        if (this.property == null) {
            Collections.sort(children, new Comparator<Node>(){

                @Override
                public int compare(Node o1, Node o2) {
                    return NodeUtil.getName((Node)o2).compareTo(NodeUtil.getName((Node)o1));
                }
            });
        } else {
            Collections.sort(children, new Comparator<Node>(){

                @Override
                public int compare(Node o1, Node o2) {
                    return StringUtils.defaultString((String)PropertyUtil.getString((Node)o2, (String)NodeSortTask.this.property)).compareTo(StringUtils.defaultString((String)PropertyUtil.getString((Node)o1, (String)NodeSortTask.this.property)));
                }
            });
        }
        Node previous = null;
        for (Node content : children) {
            if (previous != null) {
                parent.orderBefore(content.getName(), previous.getName());
            }
            previous = content;
        }
    }
}

