/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.jcr.util.MetaDataUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.TaskExecutionException;
import it.openutils.mgnltasks.AnonymousUserSetupTask;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResult;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.AdvancedResultItem;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.Criteria;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.JCRCriteriaFactory;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Criterion;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Order;
import net.sourceforge.openutils.mgnlcriteria.jcr.query.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceParagraphTask
extends AbstractRepositoryTask {
    private final String actualTemplate;
    private final String newTemplate;
    private Logger log = LoggerFactory.getLogger(AnonymousUserSetupTask.class);

    public ReplaceParagraphTask(String actualTemplate, String newTemplate) {
        super("Replacing template " + actualTemplate + " with " + newTemplate, "Replacing template " + actualTemplate + " with " + newTemplate);
        this.actualTemplate = actualTemplate;
        this.newTemplate = newTemplate;
    }

    protected void doExecute(InstallContext installContext) throws RepositoryException, TaskExecutionException {
        Criteria criteria = JCRCriteriaFactory.createCriteria().setWorkspace("website").add((Criterion)Restrictions.eq((String)"@jcr:primaryType", (Object)"mgnl:component")).add((Criterion)Restrictions.eq((String)"MetaData/mgnl:template", (Object)this.actualTemplate)).addOrder(Order.desc((String)"@jcr:score"));
        this.log.debug("Running query: {}", (Object)criteria.toXpathExpression());
        AdvancedResult result = criteria.execute();
        for (AdvancedResultItem page : result.getItems()) {
            this.log.warn("Replacing template {} with {} in {}", new Object[]{MetaDataUtil.getTemplate((Node)page), this.newTemplate, page.getHandle()});
            MetaDataUtil.getMetaData((Node)page).setTemplate(this.newTemplate);
        }
    }
}

