/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.jcr.util.NodeUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.TaskExecutionException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.commons.predicate.Predicate;

public class SetNodeOrderTask
extends AbstractRepositoryTask {
    private String repository;
    private String parentNode;
    private String[] nodesOrder;

    public SetNodeOrderTask(String repository, String parentNode, String[] nodesOrder) {
        super("Set order in node " + parentNode, "Set order in node " + parentNode);
        this.repository = repository;
        this.parentNode = parentNode;
        this.nodesOrder = nodesOrder;
    }

    protected void doExecute(InstallContext installContext) throws RepositoryException, TaskExecutionException {
        Session session = installContext.getJCRSession(this.repository);
        Node parent = session.getNode(this.parentNode);
        List children = NodeUtil.asList((Iterable)NodeUtil.getNodes((Node)parent, (Predicate)NodeUtil.EXCLUDE_META_DATA_FILTER));
        final List<String> orderedList = Arrays.asList(this.nodesOrder);
        Collections.sort(children, new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                Integer index1 = orderedList.indexOf(NodeUtil.getName((Node)o1));
                Integer index2 = orderedList.indexOf(NodeUtil.getName((Node)o2));
                if (index1 < 0) {
                    index1 = Integer.MAX_VALUE;
                }
                if (index2 < 0) {
                    index2 = Integer.MAX_VALUE;
                }
                return index2.compareTo(index1);
            }
        });
        Node previous = null;
        for (Node content : children) {
            if (previous != null) {
                parent.orderBefore(content.getName(), previous.getName());
            }
            previous = content;
        }
    }
}

