/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.init.MagnoliaConfigurationProperties;
import info.magnolia.module.DefaultModuleVersionHandler;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.Delta;
import info.magnolia.module.delta.DeltaBuilder;
import info.magnolia.module.model.Version;
import info.magnolia.objectfactory.Components;
import it.openutils.mgnltasks.BootstrapMissingNodesTask;
import it.openutils.mgnltasks.ModuleConfigBootstrapTask;
import it.openutils.mgnltasks.UpdateModuleVersionTask;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleModuleVersionHandler
extends DefaultModuleVersionHandler {
    protected Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected Set<String> includedRepositoriesInBootstrap = new HashSet<String>();

    public SimpleModuleVersionHandler() {
        this.includedRepositoriesInBootstrap.add("config");
    }

    public void addIncludedRepositoryInmBootstrap(String repository) {
        this.includedRepositoriesInBootstrap.add(repository);
    }

    public List<Delta> getDeltas(InstallContext ctx, Version from) {
        if (from == null) {
            this.log.info("Actual version not set");
            List deltas = super.getDeltas(ctx, from);
            ((Delta)deltas.get(0)).getTasks().add(new BootstrapMissingNodesTask(ctx.getCurrentModuleDefinition().getName() + "-nooverwrite"));
            if (((MagnoliaConfigurationProperties)Components.getComponent(MagnoliaConfigurationProperties.class)).getBooleanProperty("magnolia.develop") && (StringUtils.isEmpty((String)((MagnoliaConfigurationProperties)Components.getComponent(MagnoliaConfigurationProperties.class)).getProperty("magnolia.bootstrapdev")) || StringUtils.contains((String)((MagnoliaConfigurationProperties)Components.getComponent(MagnoliaConfigurationProperties.class)).getProperty("magnolia.bootstrapdev"), (String)ctx.getCurrentModuleDefinition().getName()))) {
                ((Delta)deltas.get(0)).getTasks().add(new BootstrapMissingNodesTask(ctx.getCurrentModuleDefinition().getName() + "-dev"));
            }
            return deltas;
        }
        String modulename = ctx.getCurrentModuleDefinition().getName();
        Version to = ctx.getCurrentModuleDefinition().getVersion();
        ArrayList<Delta> deltas = new ArrayList<Delta>();
        if (((MagnoliaConfigurationProperties)Components.getComponent(MagnoliaConfigurationProperties.class)).getBooleanProperty(modulename + ".update.disabled")) {
            return deltas;
        }
        if (!to.isEquivalent(from) || "${project.version}".equals(ObjectUtils.toString((Object)from)) || "SNAPSHOT".equals(from.getClassifier())) {
            this.log.info("Updating from version {}", (Object)from);
            DeltaBuilder delta = DeltaBuilder.update((Version)to, (String)"Update to current version");
            this.addModuleConfigBootstrapTasks(modulename, (Delta)delta);
            delta.getTasks().add(new BootstrapMissingNodesTask(modulename + "-nooverwrite"));
            delta.getTasks().add(new UpdateModuleVersionTask());
            deltas.add((Delta)delta);
        } else {
            this.log.info("Version {} already installed, no update tasks to run", (Object)from);
        }
        return deltas;
    }

    protected void addModuleConfigBootstrapTasks(String modulename, Delta delta) {
        delta.getTasks().add(new ModuleConfigBootstrapTask(modulename, this.includedRepositoriesInBootstrap));
    }

    protected boolean samplesEnabled() {
        return ((MagnoliaConfigurationProperties)Components.getComponent(MagnoliaConfigurationProperties.class)).getBooleanProperty("magnolia.bootstrap.samples");
    }
}

