/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks.dev;

import info.magnolia.cms.core.Path;
import info.magnolia.cms.security.AccessDeniedException;
import info.magnolia.cms.util.AlertUtil;
import info.magnolia.context.MgnlContext;
import info.magnolia.importexport.DataTransporter;
import info.magnolia.jcr.predicate.AbstractPredicate;
import info.magnolia.jcr.util.NodeUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.ModuleRegistry;
import info.magnolia.module.admininterface.TemplatedMVCHandler;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.TaskExecutionException;
import info.magnolia.objectfactory.Components;
import info.magnolia.repository.RepositoryManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.commons.predicate.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleDevelopmentUtilsPage
extends TemplatedMVCHandler {
    private boolean templates;
    private boolean paragraphs;
    private boolean dialogs;
    private boolean pages;
    private boolean website;
    private boolean media;
    private boolean data;
    private boolean users;
    private boolean groups;
    private boolean roles;
    private boolean virtualURIs;
    private String rootdir;
    private String parentpath;
    private String repository;
    private String module;
    public static Logger log = LoggerFactory.getLogger(ModuleDevelopmentUtilsPage.class);

    public ModuleDevelopmentUtilsPage(String name, HttpServletRequest request, HttpServletResponse response) {
        super(name, request, response);
    }

    public boolean isTemplates() {
        return this.templates;
    }

    public boolean isParagraphs() {
        return this.paragraphs;
    }

    public boolean isDialogs() {
        return this.dialogs;
    }

    public boolean isPages() {
        return this.pages;
    }

    public void setPages(boolean pages) {
        this.pages = pages;
    }

    public boolean isWebsite() {
        return this.website;
    }

    public boolean isMedia() {
        return this.media;
    }

    public void setMedia(boolean media) {
        this.media = media;
    }

    public boolean isData() {
        return this.data;
    }

    public void setData(boolean data) {
        this.data = data;
    }

    public boolean isUsers() {
        return this.users;
    }

    public boolean isGroups() {
        return this.groups;
    }

    public boolean isRoles() {
        return this.roles;
    }

    public String getRootdir() {
        return this.rootdir;
    }

    public String getParentpath() {
        return this.parentpath;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setDialogs(boolean dialogs) {
        this.dialogs = dialogs;
    }

    public void setParagraphs(boolean paragraphs) {
        this.paragraphs = paragraphs;
    }

    public void setTemplates(boolean templates) {
        this.templates = templates;
    }

    public void setRootdir(String rootdir) {
        this.rootdir = rootdir;
    }

    public void setWebsite(boolean website) {
        this.website = website;
    }

    public void setParentpath(String parentpath) {
        this.parentpath = parentpath;
    }

    public void setGroups(boolean groups) {
        this.groups = groups;
    }

    public void setRoles(boolean roles) {
        this.roles = roles;
    }

    public void setUsers(boolean users) {
        this.users = users;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public boolean isVirtualURIs() {
        return this.virtualURIs;
    }

    public void setVirtualURIs(boolean virtualURIs) {
        this.virtualURIs = virtualURIs;
    }

    public Iterator<String> getRepositories() {
        return ((RepositoryManager)Components.getComponent(RepositoryManager.class)).getWorkspaceNames().iterator();
    }

    public Set<String> getModules() {
        return ((ModuleRegistry)Components.getComponent(ModuleRegistry.class)).getModuleNames();
    }

    public String backup() throws RepositoryException {
        Session hm = MgnlContext.getJCRSession((String)"config");
        Session session = hm.getWorkspace().getSession();
        try {
            Node moduleroot = hm.getNode("/modules/" + this.module);
            if (this.templates) {
                this.exportChildren("config", session, moduleroot, "templates", new String[]{"mgnl:content", "mgnl:contentNode"}, false);
            }
            if (this.paragraphs) {
                this.exportChildren("config", session, moduleroot, "paragraphs", new String[]{"mgnl:content", "mgnl:contentNode"}, false);
            }
            if (this.pages) {
                this.exportChildren("config", session, moduleroot, "pages", new String[]{"mgnl:content", "mgnl:contentNode"}, false);
            }
            if (this.dialogs) {
                this.exportChildren("config", session, moduleroot, "dialogs", new String[]{"mgnl:content", "mgnl:contentNode"}, true);
            }
            if (this.virtualURIs) {
                this.exportChildren("config", session, moduleroot, "virtualURIMapping", new String[]{"mgnl:contentNode"}, true);
            }
            AlertUtil.setMessage((String)("Backup done to " + new File(Path.getAbsoluteFileSystemPath((String)this.rootdir)).getCanonicalPath()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            AlertUtil.setMessage((String)("Error while processing module " + this.module), (Exception)e);
        }
        if (this.website) {
            this.extractWorkspaceRoots("website");
        }
        if (this.media && ((RepositoryManager)Components.getComponent(RepositoryManager.class)).hasWorkspace("media")) {
            this.extractWorkspaceRoots("media");
        }
        if (this.data && ((RepositoryManager)Components.getComponent(RepositoryManager.class)).hasWorkspace("data")) {
            this.extractWorkspaceRoots("data");
        }
        if (this.users) {
            this.backupChildren("users", "/admin");
        }
        if (this.groups) {
            this.extractWorkspaceRoots("usergroups");
        }
        if (this.roles) {
            this.extractWorkspaceRoots("userroles");
        }
        return this.show();
    }

    private void extractWorkspaceRoots(String repositoryName) {
        try {
            Session hm = MgnlContext.getJCRSession((String)repositoryName);
            Node wesiteRoot = hm.getRootNode();
            Iterable children = NodeUtil.getNodes((Node)wesiteRoot, (Predicate)NodeUtil.EXCLUDE_META_DATA_FILTER);
            for (Node node : children) {
                this.exportNode(repositoryName, hm.getWorkspace().getSession(), node, true);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            AlertUtil.setMessage((String)("Error while processing " + repositoryName + " repository"), (Exception)e);
        }
    }

    private void backupChildren(String repository, String parentpath) throws RepositoryException {
        Session hm = MgnlContext.getJCRSession((String)repository);
        Node parentNode = null;
        try {
            parentNode = hm.getNode(parentpath);
        }
        catch (RepositoryException e) {
            return;
        }
        try {
            Iterable children = NodeUtil.getNodes((Node)parentNode, (Predicate)NodeUtil.EXCLUDE_META_DATA_FILTER);
            for (Node exported : children) {
                this.exportNode(repository, hm.getWorkspace().getSession(), exported, false);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            AlertUtil.setMessage((String)"Error while processing actions", (Exception)e);
        }
    }

    private void exportChildren(String repository, Session session, Node moduleroot, String path, final String[] itemTypes, boolean exportContentContainingContentNodes) throws PathNotFoundException, RepositoryException, AccessDeniedException, FileNotFoundException, IOException {
        Node templateRoot = null;
        try {
            templateRoot = moduleroot.getNode(path);
        }
        catch (PathNotFoundException e) {
            return;
        }
        HashSet<String> alreadyExported = new HashSet<String>();
        Iterable children = NodeUtil.getNodes((Node)templateRoot, (Predicate)new AbstractPredicate<Node>(){

            public boolean evaluateTyped(Node node) {
                for (String type : itemTypes) {
                    try {
                        if (!node.getPrimaryNodeType().getName().equals(type)) continue;
                        return true;
                    }
                    catch (RepositoryException e) {
                        return false;
                    }
                }
                return false;
            }
        });
        for (Node node : children) {
            boolean hasproperties = false;
            PropertyIterator properties = node.getProperties();
            while (properties.hasNext()) {
                Property property = properties.nextProperty();
                if (StringUtils.contains((String)property.getName(), (String)".")) continue;
                hasproperties = true;
                break;
            }
            if (hasproperties && (!exportContentContainingContentNodes || !NodeUtil.getNodes((Node)node, (String)"mgnl:contentNode").iterator().hasNext())) continue;
            String current = node.getPath();
            boolean dontexport = false;
            for (String already : alreadyExported) {
                if (!current.startsWith(already)) continue;
                dontexport = true;
                break;
            }
            if (dontexport) continue;
            alreadyExported.add(node.getPath() + "/");
            this.exportNode(repository, session, node, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportNode(String repository, Session session, Node exported, boolean dev) throws IOException, RepositoryException {
        String handle = exported.getPath();
        String xmlName = repository + StringUtils.replace((String)handle, (String)"/", (String)".") + ".xml";
        xmlName = DataTransporter.encodePath((String)xmlName, (String)".", (String)"UTF-8");
        File folder = new File(Path.getAbsoluteFileSystemPath((String)(dev && !StringUtils.contains((String)this.rootdir, (String)"-dev") ? this.rootdir + "-dev" : this.rootdir)));
        folder.mkdirs();
        File xmlFile = new File(folder.getAbsoluteFile(), xmlName);
        FileOutputStream fos = new FileOutputStream(xmlFile);
        try {
            DataTransporter.executeExport((OutputStream)fos, (boolean)false, (boolean)true, (Session)session, (String)handle, (String)repository, (String)".xml");
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    public static class AddDevPageToMenuTask
    extends AbstractRepositoryTask {
        private final String module2;
        private final String bootstrapRootDir;

        public AddDevPageToMenuTask(String module, String bootstrapRootDir) {
            super("Dev page for module " + module, "");
            this.module2 = module;
            this.bootstrapRootDir = bootstrapRootDir;
        }

        protected void doExecute(InstallContext installContext) throws RepositoryException, TaskExecutionException {
            Node menu;
            Session session = installContext.getJCRSession("config");
            String pagename = "development-" + this.module2;
            Node pages = NodeUtil.createPath((Node)session.getRootNode(), (String)("modules/" + this.module2 + "/pages"), (String)"mgnl:content");
            if (!pages.hasNode(pagename)) {
                Node page = pages.addNode(pagename, "mgnl:contentNode");
                page.setProperty("class", ModuleDevelopmentUtilsPage.class.getName());
            }
            if (!(menu = session.getNode("/modules/adminInterface/config/menu/tools")).hasNode(pagename)) {
                Node page = menu.addNode(pagename, "mgnl:contentNode");
                page.setProperty("icon", "/.resources/tasks/ico16-save.png");
                page.setProperty("label", "Tools * " + this.module2);
                page.setProperty("onclick", "MgnlAdminCentral.showContent('/.magnolia/pages/" + pagename + ".html?module=" + this.module2 + "&rootdir=" + this.bootstrapRootDir + "');");
            }
        }
    }
}

