/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnlutils.el;

import info.magnolia.context.MgnlContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.math.NumberUtils;

public class MgnlPagingElFunctions {
    public static List<Page> pageList(int total, int visible, String param) {
        int next;
        Map parameters = MgnlContext.getParameters();
        StringBuffer sb = new StringBuffer();
        sb.append("?");
        boolean first = true;
        for (Map.Entry entry : parameters.entrySet()) {
            String[] parameterValues;
            String key = (String)entry.getKey();
            if (StringUtils.equals((String)((String)entry.getKey()), (String)param)) continue;
            if (!first) {
                sb.append("&amp;");
            }
            if ((parameterValues = MgnlContext.getParameterValues((String)key)) != null) {
                for (int j = 0; j < parameterValues.length; ++j) {
                    String value = parameterValues[j];
                    sb.append(key);
                    sb.append("=");
                    sb.append(value);
                    if (j + 1 >= parameterValues.length) continue;
                    sb.append("&amp;");
                }
            }
            first = false;
        }
        if (!first) {
            sb.append("&amp;");
        }
        sb.append(param);
        sb.append("=");
        String baseUrl = sb.toString();
        ArrayList<Page> result = new ArrayList<Page>();
        int current = Math.max(1, NumberUtils.toInt((String)MgnlContext.getParameter((String)param), (int)1));
        int start = Math.max(1, Math.min(current - visible / 2, total - visible + 1));
        int end = Math.min(start + visible, total);
        Page page = new Page(1, current == 1, baseUrl);
        page.setLabel("&laquo;&laquo;");
        page.setActive(current != 1);
        result.add(page);
        page.setCssclass("page-first");
        int previous = Math.max(current - 1, 1);
        page = new Page(previous, current == previous, baseUrl);
        page.setLabel("&laquo;");
        page.setActive(current != previous);
        result.add(page);
        page.setCssclass("page-previous");
        for (int j = start; j <= end; ++j) {
            page = new Page(j, current == j, baseUrl);
            page.setLabel(Integer.toString(j));
            page.setCssclass("page-numbered");
            result.add(page);
        }
        page = new Page(next, current == (next = Math.min(current + 1, total)), baseUrl);
        page.setLabel("&raquo;");
        page.setActive(current != next);
        page.setCssclass("page-next");
        result.add(page);
        page = new Page(total, current == total, baseUrl);
        page.setLabel("&raquo;&raquo;");
        page.setActive(current != total);
        page.setCssclass("page-last");
        result.add(page);
        return result;
    }

    public static class Page {
        private int number;
        boolean current;
        private String url;
        private String label;
        private boolean active;
        private String cssclass;

        public Page(int number, boolean current, String baseurl) {
            this.number = number;
            this.current = current;
            this.url = baseurl;
            this.active = true;
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }

        public boolean isCurrent() {
            return this.current;
        }

        public void setCurrent(boolean current) {
            this.current = current;
        }

        public String getUrl() {
            return this.url + this.number;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public String getCssclass() {
            return this.cssclass;
        }

        public void setCssclass(String cssclass) {
            this.cssclass = cssclass;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SIMPLE_STYLE).append("number", this.number).append("url", (Object)this.url).append("active", this.active).append("current", this.current).append("label", (Object)this.label).append("cssclass", (Object)this.cssclass).toString();
        }
    }
}

