/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnlutils.el;

import info.magnolia.cms.beans.config.ServerConfiguration;
import info.magnolia.cms.core.AggregationState;
import info.magnolia.cms.core.Path;
import info.magnolia.cms.i18n.I18nContentSupport;
import info.magnolia.cms.i18n.MessagesManager;
import info.magnolia.cms.security.PermissionUtil;
import info.magnolia.cms.security.SecurityUtil;
import info.magnolia.cms.security.User;
import info.magnolia.cms.security.auth.Entity;
import info.magnolia.context.MgnlContext;
import info.magnolia.init.MagnoliaConfigurationProperties;
import info.magnolia.jaas.principal.EntityImpl;
import info.magnolia.jcr.util.NodeUtil;
import info.magnolia.jcr.wrapper.HTMLEscapingNodeWrapper;
import info.magnolia.link.LinkException;
import info.magnolia.link.LinkUtil;
import info.magnolia.objectfactory.Components;
import it.openutils.mgnlutils.el.MgnlUtilsDeprecatedAdapters;
import it.openutils.mgnlutils.util.NodeUtilsExt;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MgnlUtilsElFunctions {
    private static Logger log = LoggerFactory.getLogger(MgnlUtilsElFunctions.class);

    public static boolean firstPageWithCollection(String collectionName) {
        Node actpage = MgnlUtilsDeprecatedAdapters.getCurrentContent();
        if (actpage == null) {
            return false;
        }
        try {
            while (actpage.getDepth() > 1) {
                if (!(actpage = actpage.getParent()).hasNode(collectionName) || !actpage.getNode(collectionName).hasNodes()) continue;
                MgnlUtilsDeprecatedAdapters.setCurrentContent(actpage);
                return true;
            }
        }
        catch (RepositoryException e) {
            log.error("{} looking for collection {} in {}: {}", new Object[]{((Object)((Object)e)).getClass().getName(), collectionName, NodeUtil.getPathIfPossible((Node)actpage), e.getMessage()});
        }
        return false;
    }

    public static Node contentByPath(String path, String repository) {
        if (path == null || repository == null) {
            return null;
        }
        Node node = NodeUtilsExt.getNodeByIdOrPath(repository, path);
        return node;
    }

    public static Map<String, Object> getRequestAttributeMap() {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        HttpServletRequest request = MgnlContext.getWebContext().getRequest();
        Enumeration attributeNames = request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String key = (String)attributeNames.nextElement();
            attrs.put(key, request.getAttribute(key));
            attrs.put(key, key);
        }
        return attrs;
    }

    public static String message(String key) {
        String value = MessagesManager.getMessages((Locale)((I18nContentSupport)Components.getComponent(I18nContentSupport.class)).getLocale()).get(key);
        return value;
    }

    public static String messageWithArgs(String key, Object[] arguments) {
        String value = MessagesManager.getMessages((Locale)((I18nContentSupport)Components.getComponent(I18nContentSupport.class)).getLocale()).get(key, arguments);
        return value;
    }

    public static boolean develop() {
        return ((MagnoliaConfigurationProperties)Components.getComponent(MagnoliaConfigurationProperties.class)).getBooleanProperty("magnolia.develop");
    }

    public static String link(String uuidOrPathOrUrl) {
        String cleanedurl = StringUtils.replace((String)StringUtils.trim((String)uuidOrPathOrUrl), (String)"&", (String)"&amp;");
        String contextPath = MgnlUtilsElFunctions.safeContextPath();
        if (StringUtils.isBlank((String)cleanedurl)) {
            return contextPath;
        }
        if (cleanedurl.startsWith("http") || cleanedurl.startsWith("#")) {
            return cleanedurl;
        }
        if (cleanedurl.startsWith("/")) {
            cleanedurl = ((I18nContentSupport)Components.getComponent(I18nContentSupport.class)).toI18NURI(cleanedurl);
            cleanedurl = contextPath + cleanedurl;
            return MgnlUtilsElFunctions.addDefaultExtension(cleanedurl);
        }
        try {
            cleanedurl = MgnlUtilsElFunctions.safeContextPath() + LinkUtil.convertUUIDtoURI((String)cleanedurl, (String)"website");
        }
        catch (LinkException e) {
            log.debug("Failed to parse links with from " + MgnlContext.getAggregationState().getCurrentURI() + e.getMessage());
        }
        return cleanedurl;
    }

    private static String addDefaultExtension(String url) {
        String defaultExtension;
        String configuredExtension = ((ServerConfiguration)Components.getComponent(ServerConfiguration.class)).getDefaultExtension();
        if (!(!StringUtils.isNotBlank((String)configuredExtension) || url.endsWith(defaultExtension = "." + configuredExtension) || StringUtils.contains((String)url, (String)".") || StringUtils.contains((String)url, (String)"?") || StringUtils.endsWith((String)url, (String)"/"))) {
            return url + defaultExtension;
        }
        return url;
    }

    public static String tolinkOrText(String tabseparatedstring) {
        if (StringUtils.isBlank((String)tabseparatedstring)) {
            return "";
        }
        String[] splitted = StringUtils.split((String)tabseparatedstring, (String)"\t");
        if (splitted.length > 1) {
            String url = MgnlUtilsElFunctions.link(splitted[1]);
            boolean external = false;
            if (splitted.length > 2 && "true".equals(StringUtils.trim((String)splitted[2]))) {
                external = true;
            }
            StringBuilder sb = new StringBuilder();
            if (!StringUtils.isBlank((String)url)) {
                sb.append("<a href=\"");
                sb.append(url);
                if (external) {
                    sb.append("\" class=\"external");
                }
                sb.append("\">");
                sb.append(splitted[0]);
                sb.append("</a>");
            } else {
                sb.append(splitted[0]);
            }
            return sb.toString();
        }
        if (splitted[0].equals("false") || splitted[0].equals("true")) {
            return "";
        }
        return splitted[0];
    }

    public static int countNodesInCollection(Object content, String subnode) {
        Node node = MgnlUtilsDeprecatedAdapters.toNode(content);
        int count = 0;
        if (content != null) {
            try {
                if (node.hasNode(subnode)) {
                    Node collection = node.getNode(subnode);
                    Iterator iterator = NodeUtil.getNodes((Node)node, (String)collection.getPrimaryNodeType().getName()).iterator();
                    while (iterator.hasNext()) {
                        ++count;
                    }
                }
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        return count;
    }

    public static int countSubpages(Object content) {
        Node node = MgnlUtilsDeprecatedAdapters.toNode(content);
        if (node == null) {
            return 0;
        }
        int count = 0;
        try {
            Iterator iterator = NodeUtil.getNodes((Node)node, (String)"mgnl:page").iterator();
            while (iterator.hasNext()) {
                ++count;
            }
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
        }
        return count;
    }

    @Deprecated
    public static Collection<Node> subpages(Object content) {
        Iterable nodes;
        Node node = MgnlUtilsDeprecatedAdapters.toNode(content);
        if (node == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            nodes = NodeUtil.getNodes((Node)node, (String)"mgnl:page");
        }
        catch (RepositoryException e) {
            return Collections.EMPTY_LIST;
        }
        Iterator iterator = nodes.iterator();
        ArrayList<Node> result = new ArrayList<Node>();
        while (iterator.hasNext()) {
            Node Node2 = (Node)iterator.next();
            result.add(Node2);
        }
        return result;
    }

    public static boolean userInRole(String role) {
        return MgnlContext.getUser().hasRole(role);
    }

    public static boolean isPage(Object content) {
        Node node = MgnlUtilsDeprecatedAdapters.toNode(content);
        if (node != null) {
            try {
                return NodeUtil.isNodeType((Node)node, (String)"mgnl:page");
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return false;
    }

    public static Node getPage(Object content) {
        Node node = MgnlUtilsDeprecatedAdapters.toNode(content);
        try {
            while (node != null && !NodeUtil.isNodeType((Node)node, (String)"mgnl:page")) {
                if (node.getDepth() <= 1) {
                    node = null;
                    continue;
                }
                node = node.getParent();
            }
        }
        catch (RepositoryException e) {
            log.debug("Got a {} while loading parent of {}: {}", new Object[]{((Object)((Object)e)).getClass().getName(), NodeUtil.getPathIfPossible((Node)node), e.getMessage()});
            return null;
        }
        return node;
    }

    public static String getValidatedLabel(String value) {
        if (value == null) {
            return null;
        }
        return Path.getValidatedLabel((String)value);
    }

    public static boolean isStringInSeparatedList(String list, String value, String separator) {
        if (StringUtils.isNotEmpty((String)list) && StringUtils.isNotEmpty((String)value)) {
            String[] listValues;
            for (String v : listValues = list.split(separator)) {
                if (!v.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isLine(String list, String value) {
        return MgnlUtilsElFunctions.isStringInSeparatedList(list, value, "\r\n") || MgnlUtilsElFunctions.isStringInSeparatedList(list, value, "\n");
    }

    public static String encodeISO9075(String handle) {
        return ISO9075.encodePath((String)handle);
    }

    public static String[][] splitAndTokenize(String string) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (String line : StringUtils.splitPreserveAllTokens((String)string, (char)'\n')) {
            if (!StringUtils.isNotBlank((String)(line = StringUtils.removeEnd((String)line, (String)"\r")))) continue;
            list.add(StringUtils.splitPreserveAllTokens((String)line, (char)'\t'));
        }
        return (String[][])list.toArray((T[])new String[0][]);
    }

    public static Map<String, String> mapTokens(String[][] tokens, int keyIndex, int valueIndex) {
        HashMap<String, String> map = new HashMap<String, String>(tokens.length);
        for (String[] row : tokens) {
            if (keyIndex >= row.length || valueIndex >= row.length) continue;
            map.put(row[keyIndex], row[valueIndex]);
        }
        return map;
    }

    public static Map<String, String[]> multiMapTokens(String[][] tokens, int keyIndex, int valueIndex) {
        HashMap<String, ArrayList<String>> tmpMap = new HashMap<String, ArrayList<String>>();
        Object currentKey = null;
        for (String[] row : tokens) {
            if (keyIndex >= row.length || valueIndex >= row.length) continue;
            String key = StringUtils.trimToNull((String)row[keyIndex]);
            if (key == null) {
                key = currentKey;
            }
            if (key == null) continue;
            ArrayList<String> values = (ArrayList<String>)tmpMap.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                tmpMap.put(key, values);
            }
            values.add(row[valueIndex]);
        }
        HashMap<String, String[]> map = new HashMap<String, String[]>(tmpMap.size());
        for (Map.Entry entry : tmpMap.entrySet()) {
            map.put((String)entry.getKey(), ((List)entry.getValue()).toArray(new String[0]));
        }
        return map;
    }

    public static String baseUrl() {
        return MgnlUtilsElFunctions.baseUrlWithoutContextPath() + MgnlUtilsElFunctions.safeContextPath();
    }

    public static String toAbsoluteUrl(String relativeOrAbsolute) {
        if (StringUtils.isBlank((String)relativeOrAbsolute)) {
            return relativeOrAbsolute;
        }
        if (StringUtils.contains((String)StringUtils.substring((String)relativeOrAbsolute, (int)0, (int)10), (String)"://")) {
            return relativeOrAbsolute;
        }
        return MgnlUtilsElFunctions.baseUrl() + relativeOrAbsolute;
    }

    public static String baseUrlWithoutContextPath() {
        HttpServletRequest request = MgnlContext.getWebContext().getRequest();
        StringBuffer baseUrl = new StringBuffer();
        baseUrl.append(request.getScheme());
        baseUrl.append("://");
        baseUrl.append(request.getServerName());
        if ("http".equals(request.getScheme()) && request.getServerPort() != 80 || "https".equals(request.getScheme()) && request.getServerPort() != 443) {
            baseUrl.append(":");
            baseUrl.append(request.getServerPort());
        }
        return baseUrl.toString();
    }

    public static String pageFullUrl(Object content) {
        Node node = MgnlUtilsDeprecatedAdapters.toNode(content);
        if (node == null) {
            return null;
        }
        return MgnlUtilsElFunctions.baseUrl() + NodeUtil.getPathIfPossible((Node)node) + ".html";
    }

    public static String activePageFullUrl() {
        try {
            Node mainContent = MgnlUtilsDeprecatedAdapters.getMainContent();
            if (mainContent == null) {
                return null;
            }
            return MgnlUtilsElFunctions.baseUrl() + LinkUtil.convertUUIDtoURI((String)mainContent.getIdentifier(), (String)MgnlContext.getAggregationState().getRepository());
        }
        catch (RepositoryException e) {
            log.warn("Error generating link", (Throwable)e);
        }
        catch (LinkException e) {
            log.warn("Error generating link", (Throwable)e);
        }
        return null;
    }

    public static String repoUuidLink(Object uuid, String repo) {
        return MgnlUtilsElFunctions.link(uuid, repo, true);
    }

    public static String linkNoCtx(Object uuid, String repo) {
        return MgnlUtilsElFunctions.link(uuid, repo, false);
    }

    public static String link(Object uuid, String repo, boolean addcontextpath) {
        Node node = MgnlUtilsElFunctions.node(uuid, repo);
        if (node == null) {
            return "#";
        }
        return NodeUtilsExt.createLink(node, addcontextpath);
    }

    @Deprecated
    public static List<Node> convertToCollection(List<Object> list) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Object content : list) {
            result.add(MgnlUtilsDeprecatedAdapters.toNode(content));
        }
        return result;
    }

    public static Boolean hasChildWithTitle(Object content, String title) {
        Node node = MgnlUtilsDeprecatedAdapters.toNode(content);
        if (node == null) {
            return false;
        }
        try {
            NodeIterator children = node.getNodes();
            while (children.hasNext()) {
                Node child = (Node)children.next();
                if (!child.hasProperty("title") || !StringUtils.equalsIgnoreCase((String)child.getProperty("title").getString(), (String)title)) continue;
                return true;
            }
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
        }
        return false;
    }

    public static Collection<Node> contentChildrenOfType(Object content, String contentType) {
        Iterable nodes;
        Node node = MgnlUtilsDeprecatedAdapters.toNode(content);
        if (node == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            nodes = NodeUtil.getNodes((Node)node, (String)contentType);
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
            return Collections.EMPTY_LIST;
        }
        Iterator iterator = nodes.iterator();
        ArrayList<Node> result = new ArrayList<Node>();
        while (iterator.hasNext()) {
            result.add((Node)iterator.next());
        }
        return result;
    }

    public static String buildQuerystringExcluding(String excludedParamsWhitespaceSeparated) {
        return MgnlUtilsElFunctions.buildQuerystringInternal(StringUtils.split((String)StringUtils.defaultString((String)excludedParamsWhitespaceSeparated), (char)' '), new String[0]);
    }

    public static String buildQuerystringIncluding(String includedParamsWhitespaceSeparated) {
        return MgnlUtilsElFunctions.buildQuerystringInternal(new String[0], StringUtils.split((String)StringUtils.defaultString((String)includedParamsWhitespaceSeparated), (char)' '));
    }

    private static String buildQuerystringInternal(String[] excluded, String[] included) {
        Map parameters = MgnlContext.getParameters();
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (Map.Entry entry : parameters.entrySet()) {
            String[] parameterValues;
            String key = (String)entry.getKey();
            if (ArrayUtils.contains((Object[])excluded, (Object)key) || included != null && included.length != 0 && !ArrayUtils.contains((Object[])included, (Object)key)) continue;
            if (!first) {
                sb.append("&");
            }
            if ((parameterValues = MgnlContext.getParameterValues((String)key)) != null) {
                for (int j = 0; j < parameterValues.length; ++j) {
                    String value = parameterValues[j];
                    sb.append(MgnlUtilsElFunctions.urlencode(key));
                    sb.append("=");
                    sb.append(MgnlUtilsElFunctions.urlencode(value));
                    if (j + 1 >= parameterValues.length) continue;
                    sb.append("&");
                }
            }
            first = false;
        }
        return sb.toString();
    }

    private static String urlencode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return string;
        }
    }

    public static Node node(Object obj, String repo) {
        if (obj == null) {
            return null;
        }
        Node content = null;
        if (obj instanceof String) {
            String identifier = (String)obj;
            if (StringUtils.isBlank((String)identifier)) {
                return null;
            }
            content = NodeUtilsExt.getNodeByIdOrPath(repo, StringUtils.trim((String)identifier));
        } else {
            content = MgnlUtilsDeprecatedAdapters.toNode(obj);
        }
        return content;
    }

    public static Object userPropertyCurrent(String property) {
        return MgnlContext.getUser().getProperty(property);
    }

    public static Object userProperty(User user, String property) {
        if (user == null) {
            return null;
        }
        return user.getProperty(property);
    }

    public static Map<String, Object> userProperties() {
        Subject subject = MgnlContext.getSubject();
        Set<Entity> principalDetails = subject.getPrincipals(Entity.class);
        Iterator<Entity> entityIterator = principalDetails.iterator();
        Entity userDetails = entityIterator.next();
        if (userDetails instanceof EntityImpl) {
            try {
                Field properties = userDetails.getClass().getDeclaredField("properties");
                properties.setAccessible(true);
                Object value = properties.get(userDetails);
                return (Map)value;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public static String pagePropertyInherited(String property) {
        Node node = MgnlUtilsDeprecatedAdapters.getMainContent();
        try {
            while (node.getDepth() >= 1) {
                String value;
                if (node.hasProperty(property) && !StringUtils.isEmpty((String)(value = node.getProperty(property).getString()))) {
                    return value;
                }
                node = node.getParent();
            }
        }
        catch (RepositoryException e) {
            log.warn("{} caught while reading property {} from {}: {}", new Object[]{((Object)((Object)e)).getClass().getName(), property, NodeUtil.getPathIfPossible((Node)MgnlUtilsDeprecatedAdapters.getMainContent()), e.getMessage()});
        }
        return null;
    }

    public static void setActivePage(Object content) {
        MgnlUtilsDeprecatedAdapters.setCurrentContent(content);
    }

    public static boolean canEdit() {
        Node mainContent = MgnlUtilsDeprecatedAdapters.getMainContent();
        if (mainContent != null) {
            return NodeUtil.isGranted((Node)mainContent, (long)2L);
        }
        return false;
    }

    public static Node contentByUUID(String uuid, String repo) throws RepositoryException {
        if (StringUtils.isBlank((String)uuid)) {
            return null;
        }
        return NodeUtilsExt.getNodeByIdOrPath(repo, uuid);
    }

    public static boolean userHasRole(String role) {
        return MgnlContext.getUser().getAllRoles().contains(role);
    }

    public static boolean userHasGroup(String group) {
        return MgnlContext.getUser().getAllGroups().contains(group);
    }

    public static Node currentPage() {
        return MgnlUtilsDeprecatedAdapters.getCurrentContent();
    }

    public static Node mainPage() {
        return MgnlUtilsDeprecatedAdapters.getMainContent();
    }

    public static Node currentParagraph() {
        return MgnlUtilsDeprecatedAdapters.getCurrentContent();
    }

    public static String systemProperty(String key) {
        return ((MagnoliaConfigurationProperties)Components.getComponent(MagnoliaConfigurationProperties.class)).getProperty(key);
    }

    public static Properties systemProperties() {
        return MgnlUtilsDeprecatedAdapters.systemProperties();
    }

    public static boolean isLoggedIn() {
        return SecurityUtil.isAuthenticated();
    }

    public static boolean isEditMode() {
        Node activePage = MgnlUtilsDeprecatedAdapters.getMainContent();
        if (activePage == null) {
            return false;
        }
        AggregationState aggregationState = MgnlUtilsDeprecatedAdapters.getAggregationStateIfAvailable();
        if (aggregationState == null) {
            return false;
        }
        try {
            return ((ServerConfiguration)Components.getComponent(ServerConfiguration.class)).isAdmin() && !aggregationState.isPreviewMode() && PermissionUtil.isGranted((Node)activePage, (long)2L);
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public static boolean firstPageWithNode(String nodeName, int minlevel) {
        Node node = MgnlUtilsDeprecatedAdapters.getCurrentContent();
        if (node == null) {
            node = MgnlUtilsDeprecatedAdapters.getMainContent();
        }
        try {
            while (node.getDepth() > minlevel) {
                if (!(node = node.getParent()).hasNode(nodeName)) continue;
                MgnlUtilsDeprecatedAdapters.setCurrentContent(node);
                return true;
            }
        }
        catch (RepositoryException e) {
            log.error("Error looking for node " + nodeName + " in " + NodeUtil.getPathIfPossible((Node)node), (Throwable)e);
        }
        return false;
    }

    @Deprecated
    public static Collection<Property> nodeDataIterator(Object c, String collection) {
        Node node = MgnlUtilsDeprecatedAdapters.toNode(c);
        try {
            if (node.hasNode(collection)) {
                return Collections.EMPTY_LIST;
            }
            PropertyIterator properties = node.getNode(collection).getProperties();
            ArrayList<Property> result = new ArrayList<Property>();
            while (properties.hasNext()) {
                result.add(properties.nextProperty());
            }
            return result;
        }
        catch (RepositoryException e) {
            log.error("Error when getting nodedata collection from " + c + " / " + collection + " :" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Node ancestor(Object nodeorcontent, int level) {
        Node node = MgnlUtilsDeprecatedAdapters.toNode(nodeorcontent);
        if (node == null) {
            return null;
        }
        try {
            if (node.getDepth() < level) {
                return null;
            }
            if (node.getDepth() == level) {
                return node;
            }
            return (Node)node.getAncestor(level);
        }
        catch (RepositoryException e) {
            log.debug("Got a {} while loading level {} starting from {}: {}", new Object[]{((Object)((Object)e)).getClass().getName(), level, NodeUtil.getPathIfPossible((Node)node), e.getMessage()});
            return null;
        }
    }

    public static Node decode(Object object) {
        Node node = MgnlUtilsDeprecatedAdapters.toNode(object);
        if (node == null) {
            return null;
        }
        return NodeUtil.deepUnwrap((Node)node, HTMLEscapingNodeWrapper.class);
    }

    private static String safeContextPath() {
        if (MgnlContext.isWebContext()) {
            return MgnlContext.getContextPath();
        }
        return "";
    }
}

