/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnlutils.el;

import info.magnolia.jcr.util.NodeUtil;
import it.openutils.mgnlutils.el.NodeElResolverUtils;
import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeElResolver
extends ELResolver {
    private Logger log = LoggerFactory.getLogger(NodeElResolver.class);

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return true;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        throw new PropertyNotWritableException();
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (base == null) {
            return null;
        }
        if (NodeElResolverUtils.toNode(base) != null) {
            context.setPropertyResolved(true);
            Object result = NodeElResolverUtils.get(base, ObjectUtils.toString((Object)property));
            this.log.debug("getValue {} {} = {}", new Object[]{base, property, result});
            return result;
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (NodeElResolverUtils.toNode(base) != null) {
            context.setPropertyResolved(true);
            return Object.class;
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        Node node = NodeElResolverUtils.toNode(base);
        if (node != null) {
            ArrayList<FeatureDescriptor> list = new ArrayList<FeatureDescriptor>();
            PropertyIterator iter = null;
            try {
                iter = node.getProperties();
            }
            catch (RepositoryException e) {
                this.log.warn("Unable to read properties from {}", (Object)NodeUtil.getPathIfPossible((Node)node));
            }
            if (iter != null) {
                while (iter.hasNext()) {
                    Property property = iter.nextProperty();
                    try {
                        FeatureDescriptor descriptor = new FeatureDescriptor();
                        String name = property.getName();
                        descriptor.setName(name);
                        descriptor.setDisplayName(name);
                        descriptor.setShortDescription("");
                        descriptor.setExpert(false);
                        descriptor.setHidden(false);
                        descriptor.setPreferred(true);
                        descriptor.setValue("type", String.class);
                        descriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
                        list.add(descriptor);
                    }
                    catch (RepositoryException e) {}
                }
            }
            return list.iterator();
        }
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (NodeElResolverUtils.toNode(base) != null) {
            return Object.class;
        }
        return null;
    }
}

