/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnlutils.el;

import info.magnolia.cms.core.Content;
import info.magnolia.jcr.util.ContentMap;
import info.magnolia.jcr.util.NodeUtil;
import info.magnolia.link.LinkException;
import info.magnolia.link.LinkTransformer;
import info.magnolia.link.LinkTransformerManager;
import info.magnolia.link.LinkUtil;
import java.lang.reflect.InvocationTargetException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeElResolverUtils {
    private static Logger log = LoggerFactory.getLogger(NodeElResolverUtils.class);

    public static Node toNode(Object base) {
        if (base == null) {
            return null;
        }
        Node node = null;
        if (base instanceof Node) {
            node = (Node)base;
        } else if (base instanceof ContentMap) {
            node = ((ContentMap)base).getJCRNode();
        } else if (base instanceof Content) {
            node = ((Content)base).getJCRNode();
        }
        return node;
    }

    public static Object get(Object base, String key) {
        Node node = NodeElResolverUtils.toNode(base);
        if (node == null || key == null) {
            return null;
        }
        if (StringUtils.equals((String)key, (String)"class")) {
            return base.getClass();
        }
        if (StringUtils.equalsIgnoreCase((String)key, (String)"uuid") || StringUtils.equalsIgnoreCase((String)key, (String)"@uuid") || StringUtils.equalsIgnoreCase((String)key, (String)"@id")) {
            return NodeUtil.getNodeIdentifierIfPossible((Node)node);
        }
        if (StringUtils.equals((String)key, (String)"handle") || StringUtils.equals((String)key, (String)"@handle") || StringUtils.equals((String)key, (String)"@path") || StringUtils.equals((String)key, (String)"path")) {
            return NodeUtil.getPathIfPossible((Node)node);
        }
        if (StringUtils.equals((String)key, (String)"JCRNode")) {
            return node;
        }
        if (StringUtils.equals((String)key, (String)"@name") || StringUtils.equals((String)key, (String)"name")) {
            return NodeUtil.getName((Node)node);
        }
        if (StringUtils.equals((String)key, (String)"@nodeType")) {
            try {
                return node.getPrimaryNodeType();
            }
            catch (RepositoryException e) {
            }
        } else if (StringUtils.equals((String)key, (String)"level") || StringUtils.equals((String)key, (String)"@level") || StringUtils.equals((String)key, (String)"@depth")) {
            try {
                return node.getDepth();
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        try {
            Object property = PropertyUtils.getProperty((Object)base, (String)key);
            return property;
        }
        catch (IllegalAccessException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        try {
            Object property = PropertyUtils.getProperty((Object)node, (String)key);
            return property;
        }
        catch (IllegalAccessException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        Object nodeprop = NodeElResolverUtils.getNodeProperty(node, key);
        return nodeprop;
    }

    public static Object getNodeProperty(Node node, String keyStr) {
        try {
            if (node.hasProperty(keyStr)) {
                Property prop = node.getProperty(keyStr);
                int type = prop.getType();
                if (type == 5) {
                    return prop.getDate();
                }
                if (type != 2) {
                    if (type == 6) {
                        return prop.getBoolean();
                    }
                    if (type == 3) {
                        return prop.getLong();
                    }
                    if (type == 4) {
                        return prop.getDouble();
                    }
                    if (type == 12) {
                        return prop.getDecimal();
                    }
                    if (prop.isMultiple()) {
                        Value[] values = prop.getValues();
                        String[] valueStrings = new String[values.length];
                        for (int j = 0; j < values.length; ++j) {
                            try {
                                valueStrings[j] = values[j].getString();
                                continue;
                            }
                            catch (RepositoryException e) {
                                log.debug(e.getMessage());
                            }
                        }
                        return valueStrings;
                    }
                    try {
                        return LinkUtil.convertLinksFromUUIDPattern((String)prop.getString(), (LinkTransformer)LinkTransformerManager.getInstance().getBrowserLink(node.getPath()));
                    }
                    catch (LinkException e) {
                        log.warn("Failed to parse links with from " + prop.getName(), (Throwable)e);
                    }
                }
                return prop.getString();
            }
            if (node.hasNode(keyStr)) {
                return node.getNode(keyStr);
            }
        }
        catch (PathNotFoundException e) {
        }
        catch (RepositoryException e) {
            log.warn("Failed to retrieve {} on {} with {}", new Object[]{keyStr, node, e.getMessage()});
        }
        return null;
    }
}

