/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnlutils.filters;

import info.magnolia.cms.filters.AbstractMgnlFilter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ClientHeadersFilter
extends AbstractMgnlFilter {
    private long expirationMinutes = 1440L;
    private boolean nocache;

    public void setExpirationMinutes(long expirationMinutes) {
        this.expirationMinutes = expirationMinutes;
    }

    public void setNocache(boolean nocache) {
        this.nocache = nocache;
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.nocache) {
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, max-age=0");
            response.setDateHeader("Expires", 0L);
        } else {
            response.setHeader("Pragma", "");
            response.setHeader("Cache-Control", "max-age=" + this.expirationMinutes * 60L + ", public");
            long expiration = System.currentTimeMillis() + this.expirationMinutes * 60000L;
            response.setDateHeader("Expires", expiration);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

