/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnlutils.jmx;

import info.magnolia.init.MagnoliaConfigurationProperties;
import info.magnolia.objectfactory.Components;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxServerContextListener
implements ServletContextListener {
    private JMXConnectorServer connectorServer;
    private Logger log = LoggerFactory.getLogger(JmxServerContextListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        String serviceUrl = ((MagnoliaConfigurationProperties)Components.getComponent(MagnoliaConfigurationProperties.class)).getProperty("jmx.serviceUrl");
        if (StringUtils.isBlank((String)serviceUrl)) {
            return;
        }
        if (StringUtils.contains((String)serviceUrl, (String)"[server]")) {
            String hostname = "127.0.0.1";
            try {
                hostname = InetAddress.getLocalHost().getHostName();
                if (StringUtils.contains((String)hostname, (String)".")) {
                    hostname = StringUtils.substringBefore((String)hostname, (String)".");
                }
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            serviceUrl = StringUtils.replace((String)serviceUrl, (String)"[server]", (String)hostname);
        }
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            JMXServiceURL url = new JMXServiceURL(serviceUrl);
            this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, new HashMap(), server);
            Thread connectorThread = new Thread(){

                @Override
                public void run() {
                    try {
                        JmxServerContextListener.this.connectorServer.start();
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Could not start JMX connector server after delay", ex);
                    }
                }
            };
            connectorThread.setName("JMX Connector Thread [" + serviceUrl + "]");
            connectorThread.start();
            this.log.info("\n\n****\nJMX server started at url " + serviceUrl + "\n****\n");
        }
        catch (MalformedURLException e) {
            this.log.error("\n\n****\nUnable to start JMX server at url " + serviceUrl + " due to a " + e.getClass().getName() + " (" + e.getMessage() + ").\nYou need to add the jsr262-ri and jaxws-2.1.3 jars in the classpath in order to enable jmx over ws\n****\n");
        }
        catch (Throwable e) {
            this.log.error("Unable to start JMX server at url " + serviceUrl + " due to a " + e.getClass().getName(), e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.connectorServer == null) {
            return;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Stopping JMX connector server: " + this.connectorServer);
        }
        try {
            this.connectorServer.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

