/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnlutils.save;

import info.magnolia.cms.beans.runtime.MultipartForm;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.NodeData;
import info.magnolia.cms.security.AccessDeniedException;
import info.magnolia.module.admininterface.FieldSaveHandler;
import info.magnolia.module.admininterface.SaveHandlerImpl;
import java.util.ArrayList;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;

public class SafeMultiValueSaveHandler
extends SaveHandlerImpl
implements FieldSaveHandler {
    protected void processMultiple(Content node, String name, int type, String[] values) throws RepositoryException, PathNotFoundException, AccessDeniedException {
        ArrayList<Value> l = new ArrayList<Value>();
        if (values != null && values.length != 0) {
            for (int j = 0; j < values.length; ++j) {
                Value value;
                String valueStr = values[j];
                if (!StringUtils.isNotEmpty((String)valueStr) || (value = this.getValue(valueStr, type)) == null) continue;
                l.add(value);
            }
            if (l.size() > 0) {
                this.getOrCreateAndSet(node, name, l.toArray(new Value[l.size()]));
            }
        } else if (node.hasNodeData(name)) {
            node.deleteNodeData(name);
        }
    }

    public void save(Content parentNode, Content configNode, String name, MultipartForm form, int type, int valueType, int isRichEditValue, int encoding) throws RepositoryException, AccessDeniedException {
        this.processMultiple(parentNode, name, type, form.getParameterValues(name));
    }

    private NodeData getOrCreateAndSet(Content node, String name, Value[] value) throws AccessDeniedException, RepositoryException {
        if (node.hasNodeData(name)) {
            NodeData nodeData = node.getNodeData(name);
            if (nodeData.isMultiValue() == 0) {
                node.deleteNodeData(name);
                node.createNodeData(name, value);
            } else {
                node.setNodeData(name, value);
            }
            return node.getNodeData(name);
        }
        return node.createNodeData(name, value);
    }
}

