/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnlutils.setup;

import freemarker.ext.beans.BeanModel;
import info.magnolia.freemarker.FreemarkerConfig;
import info.magnolia.module.ModuleLifecycle;
import info.magnolia.module.ModuleLifecycleContext;
import it.openutils.mgnlutils.el.BenExposingELResolver;
import it.openutils.mgnlutils.el.NodeElResolver;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELResolver;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MgnlUtilsModule
implements ModuleLifecycle {
    @Inject
    private ServletContext servletContext;
    @Inject
    private FreemarkerConfig freemarkerConfig;
    private Logger log = LoggerFactory.getLogger(MgnlUtilsModule.class);

    public void start(ModuleLifecycleContext moduleLifecycleContext) {
        try {
            JspFactory.getDefaultFactory().getJspApplicationContext(this.servletContext).addELResolver((ELResolver)new NodeElResolver());
            this.log.info("EL resolver for javax.jcr.Node added");
            if (this.freemarkerConfig != null) {
                Map sharedVariables = this.freemarkerConfig.getSharedVariables();
                HashMap plainBeans = new HashMap();
                for (Map.Entry var : sharedVariables.entrySet()) {
                    plainBeans.put(var.getKey(), ((BeanModel)var.getValue()).getWrappedObject());
                }
                JspFactory.getDefaultFactory().getJspApplicationContext(this.servletContext).addELResolver((ELResolver)new BenExposingELResolver(plainBeans));
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void stop(ModuleLifecycleContext moduleLifecycleContext) {
    }
}

