/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnlutils.templating;

import info.magnolia.cms.core.MetaData;
import info.magnolia.context.MgnlContext;
import info.magnolia.jcr.util.MetaDataUtil;
import info.magnolia.jcr.util.NodeUtil;
import info.magnolia.rendering.model.RenderingModel;
import info.magnolia.rendering.model.RenderingModelImpl;
import info.magnolia.rendering.template.RenderableDefinition;
import it.openutils.mgnlutils.templating.ExtendedTemplate;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoGenerateTemplateModel
extends RenderingModelImpl<ExtendedTemplate> {
    private static Logger log = LoggerFactory.getLogger(AutoGenerateTemplateModel.class);

    public AutoGenerateTemplateModel(Node content, ExtendedTemplate definition, RenderingModel parent) {
        super(content, (RenderableDefinition)definition, parent);
    }

    public String execute() {
        final ExtendedTemplate templateDef = (ExtendedTemplate)this.getDefinition();
        MgnlContext.doInSystemContext((MgnlContext.Op)new MgnlContext.VoidOp(){

            public void doExec() {
                AutoGenerateTemplateModel.this.createMainArea(templateDef);
            }
        });
        return super.execute();
    }

    private void createMainArea(ExtendedTemplate templateDef) {
        String[] autogeneratelist;
        String autogenerate = templateDef.getAutogenerate();
        if (StringUtils.isEmpty((String)autogenerate)) {
            return;
        }
        for (String autogeneratepar : autogeneratelist = StringUtils.split((String)autogenerate, (String)",")) {
            String[] parDef = StringUtils.split((String)autogeneratepar, (String)"=");
            if (parDef == null || parDef.length != 2) continue;
            try {
                Node paragraph = NodeUtil.createPath((Node)this.content, (String)parDef[0], (String)"mgnl:component", (boolean)true);
                MetaData metaData = MetaDataUtil.getMetaData((Node)paragraph);
                if (!StringUtils.isEmpty((String)metaData.getTemplate())) continue;
                metaData.setTemplate(parDef[1]);
                paragraph.getSession().save();
            }
            catch (RepositoryException e) {
                log.error("Cannot create auto-generated paragraph " + autogeneratepar, (Throwable)e);
            }
        }
    }
}

