/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnlutils.templating;

import info.magnolia.jcr.util.MetaDataUtil;
import info.magnolia.jcr.util.NodeUtil;
import info.magnolia.rendering.template.TemplateAvailability;
import info.magnolia.rendering.template.TemplateDefinition;
import info.magnolia.rendering.template.configured.ConfiguredTemplateAvailability;
import info.magnolia.rendering.template.configured.ConfiguredTemplateDefinition;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedTemplate
extends ConfiguredTemplateDefinition {
    private String parentPath;
    private Set<Integer> levels = new HashSet<Integer>();
    private Set<String> parentTemplates = new HashSet<String>();
    private Set<String> repositories = new HashSet<String>();
    private String autogenerate;
    private Logger log = LoggerFactory.getLogger(ExtendedTemplate.class);

    public ExtendedTemplate() {
        super((TemplateAvailability)new ConfiguredTemplateAvailability());
    }

    public ExtendedTemplate(TemplateAvailability templateAvailability) {
        super(templateAvailability);
    }

    public String getAutogenerate() {
        return this.autogenerate;
    }

    public void setAutogenerate(String autogenerate) {
        this.autogenerate = autogenerate;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevels(String levels) {
        Set<Integer> set = this.levels;
        synchronized (set) {
            String[] levelsString;
            this.levels.clear();
            for (String string : levelsString = StringUtils.split((String)levels)) {
                this.levels.add(NumberUtils.toInt((String)string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParentTemplates(String parentTemplates) {
        Set<String> set = this.parentTemplates;
        synchronized (set) {
            String[] levelsString;
            this.parentTemplates.clear();
            for (String string : levelsString = StringUtils.split((String)parentTemplates)) {
                this.parentTemplates.add(StringUtils.trim((String)string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRepositories(String repositories) {
        Set<String> set = this.repositories;
        synchronized (set) {
            String[] repositoriesString;
            this.repositories.clear();
            for (String string : repositoriesString = StringUtils.split((String)repositories)) {
                this.repositories.add(StringUtils.trim((String)string));
            }
        }
    }

    public TemplateAvailability getTemplateAvailability() {
        final TemplateAvailability x = super.getTemplateAvailability();
        return new TemplateAvailability(){

            public boolean isAvailable(Node node, TemplateDefinition templateDefinition) {
                boolean available;
                boolean bl = x != null ? !x.isAvailable(node, templateDefinition) : (available = true);
                if (!available) {
                    return false;
                }
                if (ExtendedTemplate.this.repositories != null && !ExtendedTemplate.this.repositories.isEmpty()) {
                    try {
                        if (!ExtendedTemplate.this.repositories.contains(node.getSession().getWorkspace().getName())) {
                            return false;
                        }
                    }
                    catch (RepositoryException e) {
                        // empty catch block
                    }
                }
                if (available && ExtendedTemplate.this.levels != null && !ExtendedTemplate.this.levels.isEmpty()) {
                    try {
                        int currentLevel = node.getDepth();
                        if (!ExtendedTemplate.this.levels.contains(currentLevel)) {
                            return false;
                        }
                    }
                    catch (RepositoryException e) {
                        // empty catch block
                    }
                }
                if (available && StringUtils.isNotBlank((String)ExtendedTemplate.this.parentPath) && !StringUtils.contains((String)NodeUtil.getPathIfPossible((Node)node), (String)ExtendedTemplate.this.parentPath)) {
                    return false;
                }
                if (available && ExtendedTemplate.this.parentTemplates != null && !ExtendedTemplate.this.parentTemplates.isEmpty()) {
                    try {
                        Node parent = node.getParent();
                        while (parent.getDepth() > 0) {
                            if (ExtendedTemplate.this.parentTemplates.contains(MetaDataUtil.getMetaData((Node)parent).getTemplate())) {
                                return true;
                            }
                            parent = parent.getParent();
                        }
                    }
                    catch (RepositoryException e) {
                        ExtendedTemplate.this.log.warn("Error checking parent: " + e.getMessage(), (Throwable)e);
                    }
                    return false;
                }
                return true;
            }
        };
    }
}

