/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnlutils.util;

import info.magnolia.cms.beans.config.ServerConfiguration;
import info.magnolia.init.MagnoliaConfigurationProperties;
import info.magnolia.rendering.context.RenderingContext;
import info.magnolia.rendering.engine.RenderException;
import info.magnolia.rendering.engine.RenderExceptionHandler;
import it.openutils.mgnlutils.util.RuntimeRenderException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassicRenderExceptionHandler
implements RenderExceptionHandler {
    private static Logger log = LoggerFactory.getLogger(ClassicRenderExceptionHandler.class);
    private ServerConfiguration serverConfiguration;
    private MagnoliaConfigurationProperties configurationProperties;

    @Inject
    public ClassicRenderExceptionHandler(ServerConfiguration config) {
        this.serverConfiguration = config;
    }

    @Inject
    public void setConfigurationProperties(MagnoliaConfigurationProperties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public void handleException(RenderException renderException, RenderingContext renderingContext) {
        String path;
        try {
            path = renderingContext.getCurrentContent().getPath();
        }
        catch (RepositoryException e) {
            path = "Can't read content";
        }
        String id = renderingContext.getRenderableDefinition().getId();
        String msg = "Error while rendering [" + path + "] with template [" + id + "]: " + ExceptionUtils.getMessage((Throwable)renderException);
        if (this.serverConfiguration.isAdmin() || this.configurationProperties.getBooleanProperty("magnolia.develop")) {
            log.error(msg, (Throwable)renderException);
            throw new RuntimeRenderException(renderException);
        }
        log.error(msg, (Throwable)renderException);
        try {
            PrintWriter out = this.getPrintWriterFor((Writer)renderingContext.getAppendable());
            out.write("\n <!-- ");
            out.write(msg);
            out.write("\n-->\n");
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't log template exception.", e);
        }
    }

    private PrintWriter getPrintWriterFor(Writer out) {
        return out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
    }

    protected void inPublicMode(String msg, RenderException renderException, PrintWriter out) {
        log.error(msg, (Throwable)renderException);
    }
}

