/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnlutils.util;

import info.magnolia.cms.core.AggregationState;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.Path;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.content2bean.Content2BeanException;
import info.magnolia.content2bean.Content2BeanUtil;
import info.magnolia.context.MgnlContext;
import info.magnolia.jcr.RuntimeRepositoryException;
import info.magnolia.jcr.decoration.ContentDecoratorUtil;
import info.magnolia.jcr.util.NodeUtil;
import info.magnolia.jcr.util.PropertyUtil;
import info.magnolia.jcr.wrapper.ChannelVisibilityContentDecorator;
import info.magnolia.jcr.wrapper.DelegateSessionWrapper;
import info.magnolia.jcr.wrapper.DelegateWorkspaceWrapper;
import info.magnolia.jcr.wrapper.I18nNodeWrapper;
import info.magnolia.link.LinkFactory;
import info.magnolia.link.LinkTransformerManager;
import java.util.regex.Pattern;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.apache.commons.lang.StringUtils;

public class NodeUtilsExt {
    private static Pattern UUID_PATTERN = Pattern.compile("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$");

    public static boolean exists(Session session, String absolutepath) {
        try {
            return session.getRootNode().hasNode(StringUtils.stripStart((String)absolutepath, (String)"/"));
        }
        catch (RepositoryException e) {
            throw new RuntimeRepositoryException(e);
        }
    }

    public static Node getNodeIfExists(Session session, String absolutepath) {
        if (NodeUtilsExt.exists(session, absolutepath)) {
            try {
                return NodeUtilsExt.wrap(session.getNode(absolutepath));
            }
            catch (RepositoryException e) {
                throw new RuntimeRepositoryException(e);
            }
        }
        return null;
    }

    public static boolean deleteIfExisting(Session session, String absolutepath) {
        if (NodeUtilsExt.exists(session, absolutepath)) {
            try {
                session.getNode(absolutepath).remove();
            }
            catch (RepositoryException e) {
                throw new RuntimeRepositoryException(e);
            }
            return true;
        }
        return false;
    }

    public static boolean setPropertyIfDifferent(Node node, String propertyname, Object propertyvalue) {
        return NodeUtilsExt.setPropertyIfDifferentFromValue(node, propertyname, propertyvalue, propertyvalue);
    }

    public static boolean setPropertyIfDifferentFromValue(Node node, String propertyname, Object propertyvalue, Object oldvalue) {
        try {
            if (!node.hasProperty(propertyname) || oldvalue == null || !StringUtils.equals((String)node.getProperty(propertyname).getString(), (String)oldvalue.toString())) {
                PropertyUtil.setProperty((Node)node, (String)propertyname, (Object)propertyvalue);
                return true;
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeRepositoryException(e);
        }
        return false;
    }

    public static void deletePropertyIfExist(Node node, String propertyname) {
        try {
            if (node != null && node.hasProperty(propertyname)) {
                node.getProperty(propertyname).remove();
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeRepositoryException(e);
        }
    }

    public static Node getNodeByIdOrPath(String workspace, String uuidOrPath) {
        block7: {
            if (uuidOrPath == null) {
                return null;
            }
            if (NodeUtilsExt.isUUID(uuidOrPath)) {
                try {
                    return NodeUtilsExt.wrap(NodeUtil.getNodeByIdentifier((String)workspace, (String)uuidOrPath));
                }
                catch (ItemNotFoundException e) {
                    break block7;
                }
                catch (RepositoryException e) {
                    throw new RuntimeRepositoryException(e);
                }
            }
            try {
                return NodeUtilsExt.wrap(NodeUtilsExt.getNodeIfExists(MgnlContext.getJCRSession((String)workspace), uuidOrPath));
            }
            catch (RepositoryException e) {
                throw new RuntimeRepositoryException(e);
            }
        }
        return null;
    }

    public static boolean isUUID(String string) {
        if (StringUtils.length((String)string) != 36) {
            return false;
        }
        return UUID_PATTERN.matcher(string).find();
    }

    public static Object toBean(Node node) throws Content2BeanException {
        return NodeUtilsExt.toBean(node, null);
    }

    public static Object toBean(Node node, Class outclass) throws Content2BeanException {
        return NodeUtilsExt.toBean(node, false, outclass);
    }

    public static Object toBean(Node node, boolean recursive, Class outclass) throws Content2BeanException {
        return Content2BeanUtil.toBean((Content)ContentUtil.asContent((Node)node), (boolean)recursive, (Class)outclass);
    }

    public static String getUniqueLabel(Node parent, String label) {
        return Path.getUniqueLabel((Content)ContentUtil.asContent((Node)parent), (String)label);
    }

    public static Node wrap(Node node) {
        if (node == null) {
            return null;
        }
        if (!NodeUtil.isWrappedWith((Node)(node = NodeUtilsExt.wrapWithChannelVisibilityWrapper(node)), I18nNodeWrapper.class)) {
            node = new I18nNodeWrapper(node);
        }
        return node;
    }

    private static Node wrapWithChannelVisibilityWrapper(Node content) {
        if (ContentDecoratorUtil.isDecoratedWith((Node)content, ChannelVisibilityContentDecorator.class) || !MgnlContext.isWebContext()) {
            return content;
        }
        AggregationState aggregationState = MgnlContext.getAggregationState();
        if (aggregationState == null) {
            return content;
        }
        String channel = aggregationState.getChannel().getName();
        if (StringUtils.isEmpty((String)channel) || StringUtils.equalsIgnoreCase((String)channel, (String)"all")) {
            return content;
        }
        return new ChannelVisibilityContentDecorator(channel).wrapNode(content);
    }

    public static String getBinaryPath(Node node) {
        if (node == null) {
            return null;
        }
        return NodeUtil.getPathIfPossible((Node)node) + "/" + PropertyUtil.getString((Node)node, (String)"fileName");
    }

    public static String createLink(Node node, boolean addcontextpath) {
        if (node == null) {
            return null;
        }
        return LinkTransformerManager.getInstance().getAbsolute(addcontextpath).transform(LinkFactory.createLink((Content)ContentUtil.asContent((Node)node)));
    }

    public static Session unwrap(Session session) {
        if (session == null) {
            return null;
        }
        while (session instanceof DelegateSessionWrapper) {
            session = ((DelegateSessionWrapper)session).getWrappedSession();
        }
        return session;
    }

    public static Workspace unwrap(Workspace workspace) {
        if (workspace == null) {
            return null;
        }
        while (workspace instanceof DelegateWorkspaceWrapper) {
            workspace = ((DelegateWorkspaceWrapper)workspace).getWrappedWorkspace();
        }
        return workspace;
    }
}

