/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnlutils.virtualuri;

import info.magnolia.cms.beans.config.VirtualURIMapping;
import info.magnolia.cms.util.SimpleUrlPattern;
import info.magnolia.cms.util.UrlPattern;
import info.magnolia.context.MgnlContext;
import info.magnolia.context.WebContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class LocaleBasedVirtualURIMapping
implements VirtualURIMapping {
    private String fromURI;
    private UrlPattern pattern;
    private String toURI;
    private Map<String, String> destinations = new HashMap<String, String>();

    public List<String> getDestinations() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDestination(String mapping) {
        String[] localeToPath = StringUtils.split((String)mapping, (String)"=");
        if (localeToPath != null && localeToPath.length == 2) {
            Map<String, String> map = this.destinations;
            synchronized (map) {
                this.destinations.put(localeToPath[0], localeToPath[1]);
            }
        }
    }

    public VirtualURIMapping.MappingResult mapURI(String uri) {
        String destination = this.toURI;
        if (this.pattern != null && this.pattern.match(uri)) {
            WebContext webContext = MgnlContext.getWebContextOrNull();
            if (webContext != null) {
                String locale = webContext.getAggregationState().getLocale().toString();
                if (this.destinations != null) {
                    for (Map.Entry<String, String> hk : this.destinations.entrySet()) {
                        if (!locale.startsWith(hk.getKey())) continue;
                        destination = hk.getValue();
                        break;
                    }
                }
            }
            VirtualURIMapping.MappingResult r = new VirtualURIMapping.MappingResult();
            r.setLevel(this.pattern.getLength());
            r.setToURI(destination);
            return r;
        }
        return null;
    }

    public String getFromURI() {
        return this.fromURI;
    }

    public void setFromURI(String fromURI) {
        this.fromURI = fromURI;
        this.pattern = new SimpleUrlPattern(fromURI);
    }

    public String getToURI() {
        return this.toURI;
    }

    public void setToURI(String toURI) {
        this.toURI = toURI;
    }

    public String toString() {
        return this.fromURI + " --> " + this.toURI;
    }
}

