/*
 * This file is part of the OWL API.
 *
 * The contents of this file are subject to the LGPL License, Version 3.0.
 *
 * Copyright (C) 2011, The University of Manchester
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses/.
 *
 *
 * Alternatively, the contents of this file may be used under the terms of the Apache License, Version 2.0
 * in which case, the provisions of the Apache License Version 2.0 are applicable instead of those above.
 *
 * Copyright 2011, The University of Manchester
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* Generated By:JJTree: Do not edit this line. Node.java Version 4.3 */
/* JavaCCOptions:MULTI=false,NODE_USES_PARSER=false,VISITOR=false,TRACK_TOKENS=false,NODE_PREFIX=AST,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
package org.coode.owlapi.functionalparser;

/** All AST nodes must implement this interface. It provides basic machinery for
 * constructing the parent and child relationships between nodes. */
public interface Node {
    /** This method is called after the node has been made the current node. It
     * indicates that child nodes can now be added to it. */
    void jjtOpen();

    /** This method is called after all the child nodes have been added. */
    void jjtClose();

    /** This pair of methods are used to inform the node of its parent.
     * 
     * @param n
     *            node */
    void jjtSetParent(Node n);

    /** @return parent */
    Node jjtGetParent();

    /** This method tells the node to add its argument to the node's list of
     * children.
     * 
     * @param n
     *            node
     * @param i
     *            position */
    void jjtAddChild(Node n, int i);

    /** This method returns a child node. The children are numbered from zero,
     * left to right.
     * 
     * @param i
     *            position
     * @return node */
    Node jjtGetChild(int i);

    /** Return the number of children the node has.
     * 
     * @return number */
    int jjtGetNumChildren();
}
/*
 * JavaCC - OriginalChecksum=e3fe64a62e507f8dadcdd5f5d668b132 (do not edit this
 * line)
 */
