/*
 * This file is part of the OWL API.
 *
 * The contents of this file are subject to the LGPL License, Version 3.0.
 *
 * Copyright (C) 2011, The University of Manchester
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses/.
 *
 *
 * Alternatively, the contents of this file may be used under the terms of the Apache License, Version 2.0
 * in which case, the provisions of the Apache License Version 2.0 are applicable instead of those above.
 *
 * Copyright 2011, University of Manchester
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.coode.owlapi.rdfxml.parser;

import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;

/** Give a node in an RDF graph, which represents the main node of an OWL class
 * expression, the {@code ClassExpressionTranslator} consumes the triples that
 * represent the class expression, and translates the triples to the appropriate
 * OWL API {@code OWLClassExpression} object.
 * 
 * @author Matthew Horridge, The University Of Manchester, Bio-Health
 *         Informatics Group, Date: 08-Dec-2006 */
public interface ClassExpressionTranslator {
    /** @param mainNode
     *            mainNode
     * @param mode
     *            mode
     * @return true if matches */
    boolean matches(IRI mainNode, Mode mode);

    /** @param mainNode
     *            mainNode
     * @return true if matches strict */
    boolean matchesStrict(IRI mainNode);

    /** @param mainNode
     *            mainNode
     * @return true if lax match */
    boolean matchesLax(IRI mainNode);

    /** Translates the specified main node into an {@code OWLClassExpression}.
     * All triples used in the translation are consumed.
     * 
     * @param mainNode
     *            The main node of the set of triples that represent the class
     *            expression.
     * @return The class expression that represents the translation. */
    OWLClassExpression translate(IRI mainNode);
}
