/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import org.coode.owlapi.rdfxml.parser.AbstractClassExpressionTranslator;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class ObjectHasValueTranslator
extends AbstractClassExpressionTranslator {
    public ObjectHasValueTranslator(OWLRDFConsumer consumer) {
        super(consumer);
    }

    @Override
    public boolean matchesStrict(IRI mainNode) {
        return this.isRestrictionStrict(mainNode) && this.isObjectPropertyStrict(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isResourcePresent(mainNode, OWLRDFVocabulary.OWL_HAS_VALUE);
    }

    @Override
    public boolean matchesLax(IRI mainNode) {
        return this.isResourcePresent(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY) && this.isResourcePresent(mainNode, OWLRDFVocabulary.OWL_HAS_VALUE);
    }

    @Override
    public OWLObjectHasValue translate(IRI mainNode) {
        IRI value = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_HAS_VALUE, true);
        OWLIndividual individual = this.getConsumer().translateIndividual(value);
        IRI propertyIRI = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_PROPERTY, true);
        OWLObjectPropertyExpression property = this.getConsumer().translateObjectPropertyExpression(propertyIRI);
        return this.getDataFactory().getOWLObjectHasValue(property, individual);
    }
}

