/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.MakeClassesMutuallyDisjoint;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class MakePrimitiveSubClassesMutuallyDisjoint
extends AbstractCompositeOntologyChange {
    private final OWLClass cls;
    private final Set<OWLOntology> ontologies;
    private final OWLOntology targetOntology;
    private final boolean usePairwiseDisjointAxioms;
    private List<OWLOntologyChange> changes;

    public MakePrimitiveSubClassesMutuallyDisjoint(OWLDataFactory dataFactory, OWLClass cls, Set<OWLOntology> ontologies, OWLOntology targetOntology) {
        this(dataFactory, cls, ontologies, targetOntology, false);
    }

    public MakePrimitiveSubClassesMutuallyDisjoint(OWLDataFactory dataFactory, OWLClass cls, Set<OWLOntology> ontologies, OWLOntology targetOntology, boolean usePairwiseDisjointAxioms) {
        super(dataFactory);
        this.cls = cls;
        this.ontologies = ontologies;
        this.targetOntology = targetOntology;
        this.usePairwiseDisjointAxioms = usePairwiseDisjointAxioms;
        this.generateChanges();
    }

    private void generateChanges() {
        this.changes = new ArrayList<OWLOntologyChange>();
        HashSet<OWLClass> subclasses = new HashSet<OWLClass>();
        for (OWLOntology ont : this.ontologies) {
            for (OWLSubClassOfAxiom ax : ont.getSubClassAxiomsForSuperClass(this.cls)) {
                OWLClassExpression subCls = ax.getSubClass();
                if (subCls.isAnonymous() || subCls.asOWLClass().isDefined(this.ontologies)) continue;
                subclasses.add(subCls.asOWLClass());
            }
        }
        MakeClassesMutuallyDisjoint makeClassesMutuallyDisjoint = new MakeClassesMutuallyDisjoint(this.getDataFactory(), subclasses, this.usePairwiseDisjointAxioms, this.targetOntology);
        this.changes.addAll(makeClassesMutuallyDisjoint.getChanges());
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }
}

