/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.rdf.rdfxml.parser.AbstractState;
import org.semanticweb.owlapi.rdf.rdfxml.parser.PropertyElementList;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParser;
import org.semanticweb.owlapi.rdf.rdfxml.parser.ReificationManager;
import org.semanticweb.owlapi.rdf.rdfxml.parser.State;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.xml.sax.Attributes;

class NodeElement
extends AbstractState
implements State {
    protected final AtomicLong nextLi = new AtomicLong(1L);
    @Nullable
    protected String subjectIRI;
    @Nullable
    protected ReificationManager reificationManager;

    NodeElement(RDFParser parser) {
        super(parser);
    }

    protected String subjectIRI() {
        return OWLAPIPreconditions.verifyNotNull(this.subjectIRI);
    }

    void startDummyElement(Attributes atts) {
        this.subjectIRI = NodeID.nextAnonymousIRI();
        this.reificationManager = this.getReificationManager(atts);
    }

    @Nullable
    protected String getReificationID(Attributes atts) {
        String rdfID = this.getAttrId(atts);
        if (rdfID != null) {
            rdfID = this.parser.resolveIRI('#' + rdfID);
        }
        return OWLAPIPreconditions.verifyNotNull(this.reificationManager).getReificationID(rdfID, this.parser);
    }

    String getNextLi() {
        return "http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + this.nextLi.getAndIncrement();
    }

    String getPropertyIRI(String iri) {
        if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#li".equals(iri)) {
            return this.getNextLi();
        }
        return iri;
    }

    @Override
    public void startElement(String namespaceIRI, String localName, String qName, Attributes atts) {
        this.subjectIRI = this.getIDNodeIDAboutResourceIRI(atts);
        boolean isRDFNS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(namespaceIRI);
        this.reificationManager = this.getReificationManager(atts);
        if (!isRDFNS || !"Description".equals(localName)) {
            this.parser.statementWithResourceValue(this.subjectIRI(), "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", namespaceIRI + localName, OWLAPIPreconditions.verifyNotNull(this.reificationManager).getReificationID(null, this.parser));
        }
        this.parser.verify(atts.getIndex("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "aboutEach") != -1, "rdf:aboutEach attribute is not supported.");
        this.parser.verify(atts.getIndex("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "aboutEachPrefix") != -1, "rdf:aboutEachPrefix attribute is not supported.");
        this.propertyAttributes(this.subjectIRI(), atts, OWLAPIPreconditions.verifyNotNull(this.reificationManager));
        this.parser.pushState(new PropertyElementList(this, this.parser));
    }

    String getIDNodeIDAboutResourceIRI(Attributes atts) {
        OWLAPIPreconditions.checkNotNull(atts, "atts cannot be null");
        String result = null;
        String value = this.getAttrId(atts);
        if (value != null) {
            result = this.parser.resolveIRI('#' + value);
        }
        if ((value = this.getAttrAbout(atts)) != null) {
            this.parser.verify(result != null, "Element cannot specify both rdf:ID and rdf:about attributes.");
            result = this.parser.resolveIRI(value);
        }
        if ((value = this.getNodeId(atts)) != null) {
            this.parser.verify(result != null, "Element cannot specify both rdf:nodeID and rdf:ID or rdf:about attributes.");
            result = NodeID.getIRIFromNodeID(value);
        }
        if (result == null) {
            result = NodeID.nextAnonymousIRI();
        }
        return result;
    }

    @Nullable
    protected String getNodeId(Attributes atts) {
        return atts.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID");
    }

    @Nullable
    protected String getAttrAbout(Attributes atts) {
        return atts.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about");
    }

    @Nullable
    protected String getAttrId(Attributes atts) {
        return atts.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ID");
    }

    @Override
    public void endElement(String namespaceIRI, String localName, String qName) {
        this.parser.popState();
    }

    @Override
    public void characters(char[] data, int start, int length) {
        this.parser.verify(this.notBlank(data, start, length), "Cannot answer characters when node is expected.");
    }
}

