/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.renderer;

import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.StringLengthComparator;

public class XMLWriterNamespaceManager {
    private static final String NAMESPACE_CANNOT_BE_NULL = "namespace cannot be null";
    private final Map<String, String> prefixNamespaceMap = new TreeMap<String, String>(new StringLengthComparator());
    private final Map<String, String> namespacePrefixMap = new TreeMap<String, String>(new StringLengthComparator());
    private final Map<String, String> wellknownNamespaces = new TreeMap<String, String>(new StringLengthComparator());
    private String defaultNamespace;

    public XMLWriterNamespaceManager(String defaultNamespace) {
        this.defaultNamespace = OWLAPIPreconditions.checkNotNull(defaultNamespace, "defaultNamespace cannot be null");
    }

    public void addWellKnownNamespace(String prefix, String namespace) {
        this.wellknownNamespaces.put(OWLAPIPreconditions.checkNotNull(prefix, "prefix cannot be null"), OWLAPIPreconditions.checkNotNull(namespace, NAMESPACE_CANNOT_BE_NULL));
    }

    public void setPrefix(String prefix, String namespace) {
        OWLAPIPreconditions.checkNotNull(prefix, "prefix cannot be null");
        OWLAPIPreconditions.checkNotNull(namespace, NAMESPACE_CANNOT_BE_NULL);
        this.prefixNamespaceMap.put(prefix, namespace);
        this.namespacePrefixMap.put(namespace, prefix);
    }

    @Nullable
    public String getPrefixForNamespace(String namespace) {
        return this.namespacePrefixMap.get(OWLAPIPreconditions.checkNotNull(namespace, NAMESPACE_CANNOT_BE_NULL));
    }

    @Nullable
    public String getNamespaceForPrefix(String prefix) {
        return this.prefixNamespaceMap.get(OWLAPIPreconditions.checkNotNull(prefix, "prefix cannot be null"));
    }

    @Nullable
    public String getQName(String name) {
        OWLAPIPreconditions.checkNotNull(name, "name cannot be null");
        if (name.startsWith(this.defaultNamespace)) {
            return name.substring(this.defaultNamespace.length(), name.length());
        }
        for (Map.Entry<String, String> e : this.namespacePrefixMap.entrySet()) {
            if (!name.startsWith(e.getKey())) continue;
            String localName = name.substring(e.getKey().length(), name.length());
            return e.getValue() + ':' + localName;
        }
        return name;
    }

    public String getQName(IRI name) {
        if (name.getNamespace().equals(this.defaultNamespace)) {
            return name.prefixedBy("");
        }
        String candidate = this.namespacePrefixMap.get(name.getNamespace());
        if (candidate != null) {
            return name.prefixedBy(candidate + ':');
        }
        return name.toString();
    }

    public void createPrefixForNamespace(String namespace) {
        OWLAPIPreconditions.checkNotNull(namespace, NAMESPACE_CANNOT_BE_NULL);
        if (namespace.equals(this.defaultNamespace)) {
            return;
        }
        String prefix = this.wellknownNamespaces.get(namespace);
        if (prefix != null) {
            this.setPrefix(prefix, namespace);
        }
        if (!this.namespacePrefixMap.containsKey(namespace)) {
            int counter = 1;
            while (this.prefixNamespaceMap.get("p" + counter) != null) {
                ++counter;
            }
            this.setPrefix("p" + counter, namespace);
        }
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(String namespace) {
        this.defaultNamespace = OWLAPIPreconditions.checkNotNull(namespace, NAMESPACE_CANNOT_BE_NULL);
    }

    public Iterable<String> getPrefixes() {
        return this.prefixNamespaceMap.keySet();
    }

    public Iterable<String> getNamespaces() {
        return this.namespacePrefixMap.keySet();
    }

    public String getDefaultPrefix() {
        for (Map.Entry<String, String> e : this.prefixNamespaceMap.entrySet()) {
            if (e.getKey().isEmpty() || !e.getValue().equals(this.defaultNamespace)) continue;
            return e.getKey();
        }
        return "";
    }
}

