/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.vocab;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.HasPrefixedName;
import org.semanticweb.owlapi.model.HasShortForm;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.providers.DatatypeProvider;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

public enum OWL2Datatype implements HasIRI,
HasShortForm,
HasPrefixedName
{
    RDF_XML_LITERAL(Namespaces.RDF, "XMLLiteral", Category.CAT_STRING_WITHOUT_LANGUAGE_TAG, false, ".*"),
    RDFS_LITERAL(Namespaces.RDFS, "Literal", Category.CAT_UNIVERSAL, false, ".*"),
    RDF_PLAIN_LITERAL(Namespaces.RDF, "PlainLiteral", Category.CAT_STRING_WITH_LANGUAGE_TAG, false, ".*"),
    RDF_LANG_STRING(Namespaces.RDF, "langString", Category.CAT_STRING_WITHOUT_LANGUAGE_TAG, false, ".*"),
    OWL_REAL(Namespaces.OWL, "real", Category.CAT_NUMBER, false, ".*"),
    OWL_RATIONAL(Namespaces.OWL, "rational", Category.CAT_NUMBER, false, "(\\+|-)?([0-9]+)(\\s)*(/)(\\s)*([0-9]+)"),
    XSD_STRING(XSDVocabulary.STRING, Category.CAT_STRING_WITHOUT_LANGUAGE_TAG, false, ".*"),
    XSD_NORMALIZED_STRING(XSDVocabulary.NORMALIZED_STRING, Category.CAT_STRING_WITHOUT_LANGUAGE_TAG, false, "([^\\r\\n\\t])*"),
    XSD_TOKEN(XSDVocabulary.TOKEN, Category.CAT_STRING_WITHOUT_LANGUAGE_TAG, false, "([^\\s])(\\s([^\\s])|([^\\s]))*"),
    XSD_LANGUAGE(XSDVocabulary.LANGUAGE, Category.CAT_STRING_WITHOUT_LANGUAGE_TAG, true, "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*"),
    XSD_NAME(XSDVocabulary.NAME, Category.CAT_STRING_WITHOUT_LANGUAGE_TAG, false, ":|[A-Z]|_|[a-z]|[\\u00C0-\\u00D6]|[\\u00D8-\\u00F6]|[\\u00F8-\\u02FF]|[\\u0370-\\u037D]|[\\u037F-\\u1FFF]|[\\u200C-\\u200D]|[\\u2070-\\u218F]|[\\u2C00-\\u2FEF]|[\\u3001-\\uD7FF]|[\\uF900-\\uFDCF]|[\\uFDF0-\\uFFFD](:|[A-Z]|_|[a-z]|[\\u00C0-\\u00D6]|[\\u00D8-\\u00F6]|[\\u00F8-\\u02FF]|[\\u0370-\\u037D]|[\\u037F-\\u1FFF]|[\\u200C-\\u200D]|[\\u2070-\\u218F]|[\\u2C00-\\u2FEF]|[\\u3001-\\uD7FF]|[\\uF900-\\uFDCF]|[\\uFDF0-\\uFFFD]|\"-\"|\".\"|[0-9]|\\u00B7|[\\u0300-\\u036F]|[\\u203F-\\u2040])*"),
    XSD_NCNAME(XSDVocabulary.NCNAME, Category.CAT_STRING_WITHOUT_LANGUAGE_TAG, false, "[A-Z]|_|[a-z]|[\\u00C0-\\u00D6]|[\\u00D8-\\u00F6]|[\\u00F8-\\u02FF]|[\\u0370-\\u037D]|[\\u037F-\\u1FFF]|[\\u200C-\\u200D]|[\\u2070-\\u218F]|[\\u2C00-\\u2FEF]|[\\u3001-\\uD7FF]|[\\uF900-\\uFDCF]|[\\uFDF0-\\uFFFD]([A-Z]|_|[a-z]|[\\u00C0-\\u00D6]|[\\u00D8-\\u00F6]|[\\u00F8-\\u02FF]|[\\u0370-\\u037D]|[\\u037F-\\u1FFF]|[\\u200C-\\u200D]|[\\u2070-\\u218F]|[\\u2C00-\\u2FEF]|[\\u3001-\\uD7FF]|[\\uF900-\\uFDCF]|[\\uFDF0-\\uFFFD]|\"-\"|\".\"|[0-9]|\\u00B7|[\\u0300-\\u036F]|[\\u203F-\\u2040])*"),
    XSD_NMTOKEN(XSDVocabulary.NMTOKEN, Category.CAT_STRING_WITHOUT_LANGUAGE_TAG, false, ".*"),
    XSD_DECIMAL(XSDVocabulary.DECIMAL, Category.CAT_NUMBER, false, "(\\+|-)?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)"),
    XSD_INTEGER(XSDVocabulary.INTEGER, Category.CAT_NUMBER, false, "(\\+|-)?([0-9]+)"),
    XSD_NON_NEGATIVE_INTEGER(XSDVocabulary.NON_NEGATIVE_INTEGER, Category.CAT_NUMBER, false, "((\\+)?([0-9]+))|-(0+)"),
    XSD_NON_POSITIVE_INTEGER(XSDVocabulary.NON_POSITIVE_INTEGER, Category.CAT_NUMBER, false, "-([0-9]+)|(\\+?(0+))"),
    XSD_POSITIVE_INTEGER(XSDVocabulary.POSITIVE_INTEGER, Category.CAT_NUMBER, false, "(\\+)?(0*[1-9][0-9]*)"),
    XSD_NEGATIVE_INTEGER(XSDVocabulary.NEGATIVE_INTEGER, Category.CAT_NUMBER, false, "-(0*[1-9][0-9]*)"),
    XSD_LONG(XSDVocabulary.LONG, Category.CAT_NUMBER, true, "(\\+|-)?([0-9]+)"),
    XSD_INT(XSDVocabulary.INT, Category.CAT_NUMBER, true, "(\\+|-)?([0-9]+)"),
    XSD_SHORT(XSDVocabulary.SHORT, Category.CAT_NUMBER, true, "(\\+|-)?([0-9]+)"),
    XSD_BYTE(XSDVocabulary.BYTE, Category.CAT_NUMBER, true, "(\\+|-)?([0-9]+)"),
    XSD_UNSIGNED_LONG(XSDVocabulary.UNSIGNED_LONG, Category.CAT_NUMBER, true, "(\\+)?([0-9]+)"),
    XSD_UNSIGNED_INT(XSDVocabulary.UNSIGNED_INT, Category.CAT_NUMBER, true, "(\\+)?([0-9]+)"),
    XSD_UNSIGNED_SHORT(XSDVocabulary.UNSIGNED_SHORT, Category.CAT_NUMBER, true, "(\\+)?([0-9]+)"),
    XSD_UNSIGNED_BYTE(XSDVocabulary.UNSIGNED_BYTE, Category.CAT_NUMBER, true, "(\\+)?([0-9]+)"),
    XSD_DOUBLE(XSDVocabulary.DOUBLE, Category.CAT_NUMBER, true, "(\\+|-)?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)([Ee](\\+|-)?[0-9]+)?|(\\+|-)?INF|NaN"),
    XSD_FLOAT(XSDVocabulary.FLOAT, Category.CAT_NUMBER, true, "(\\+|-)?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)([Ee](\\+|-)?[0-9]+)?|(\\+|-)?INF|NaN"),
    XSD_BOOLEAN(XSDVocabulary.BOOLEAN, Category.CAT_BOOLEAN, true, "true|false|1|0"),
    XSD_HEX_BINARY(XSDVocabulary.HEX_BINARY, Category.CAT_BINARY, false, "([0-9a-fA-F]{2})*"),
    XSD_BASE_64_BINARY(XSDVocabulary.BASE_64_BINARY, Category.CAT_BINARY, false, "((([A-Za-z0-9+/] ?){4})*(([A-Za-z0-9+/] ?){3}[A-Za-z0-9+/]|([A-Za-z0-9+/] ?){2}[AEIMQUYcgkosw048] ?=|[A-Za-z0-9+/] ?[AQgw] ?= ?=))?"),
    XSD_ANY_URI(XSDVocabulary.ANY_URI, Category.CAT_URI, false, ".*"),
    XSD_DATE_TIME(XSDVocabulary.DATE_TIME, Category.CAT_TIME, false, "-?([1-9][0-9]{3,}|0[0-9]{3})-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T(([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9](\\.[0-9]+)?|(24:00:00(\\.0+)?))(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))?"),
    XSD_DATE_TIME_STAMP(XSDVocabulary.DATE_TIME_STAMP, Category.CAT_TIME, false, "-?([1-9][0-9]{3,}|0[0-9]{3})-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T(([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9](\\.[0-9]+)?|(24:00:00(\\.0+)?))(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))");

    public static final List<OWL2Datatype> EL_DATATYPES;
    public static final List<OWL2Datatype> RL_DATATYPES;
    private static final Map<IRI, OWL2Datatype> ALL_IRIS;
    private final String shortForm;
    private final IRI iri;
    private final Category category;
    private final boolean finite;
    private final Pattern pattern;
    private final String regExpression;
    private final String prefixedName;

    private OWL2Datatype(Namespaces namespace, String shortForm, Category category, boolean finite, String regEx) {
        this.iri = IRI.create(namespace.toString(), shortForm);
        this.shortForm = shortForm;
        this.prefixedName = namespace.getPrefixName() + ':' + shortForm;
        this.category = category;
        this.finite = finite;
        this.regExpression = regEx;
        this.pattern = Pattern.compile(regEx, 32);
    }

    private OWL2Datatype(XSDVocabulary xsd, Category category, boolean finite, String regEx) {
        this.iri = xsd.getIRI();
        this.shortForm = xsd.getShortForm();
        this.prefixedName = xsd.getPrefixedName();
        this.category = category;
        this.finite = finite;
        this.regExpression = regEx;
        this.pattern = Pattern.compile(regEx, 32);
    }

    private static Stream<OWL2Datatype> stream() {
        return Stream.of(OWL2Datatype.values());
    }

    public static Set<IRI> getDatatypeIRIs() {
        return ALL_IRIS.keySet();
    }

    public static boolean isBuiltIn(IRI datatypeIRI) {
        return ALL_IRIS.containsKey(datatypeIRI);
    }

    public static OWL2Datatype getDatatype(IRI datatype) {
        OWL2Datatype knownDatatype = ALL_IRIS.get(datatype);
        if (knownDatatype == null) {
            throw new OWLRuntimeException(datatype + " is not a built in datatype!");
        }
        return knownDatatype;
    }

    public static OWL2Datatype getDatatype(HasIRI datatype) {
        return OWL2Datatype.getDatatype(datatype.getIRI());
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getPatternString() {
        return this.regExpression;
    }

    @Override
    public String getShortForm() {
        return this.shortForm;
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    public Category getCategory() {
        return this.category;
    }

    public boolean isNumeric() {
        return this.category.equals((Object)Category.CAT_NUMBER);
    }

    public boolean isFinite() {
        return this.finite;
    }

    public Collection<OWLFacet> getFacets() {
        return this.category.getFacets();
    }

    public OWLDatatype getDatatype(DatatypeProvider factory) {
        OWLAPIPreconditions.checkNotNull(factory, "factory cannot be null");
        return factory.getOWLDatatype(this);
    }

    public boolean isInLexicalSpace(String s) {
        return this.pattern.matcher(s).matches();
    }

    @Override
    public String getPrefixedName() {
        return this.prefixedName;
    }

    public boolean matches(OWLEntity e) {
        return e.getIRI().equals(this.iri);
    }

    static {
        EL_DATATYPES = Arrays.asList(RDF_PLAIN_LITERAL, RDF_XML_LITERAL, RDFS_LITERAL, OWL_RATIONAL, OWL_REAL, XSD_DECIMAL, XSD_INTEGER, XSD_NON_NEGATIVE_INTEGER, XSD_STRING, XSD_NORMALIZED_STRING, XSD_TOKEN, XSD_NAME, XSD_NCNAME, XSD_NMTOKEN, XSD_HEX_BINARY, XSD_BASE_64_BINARY, XSD_ANY_URI, XSD_DATE_TIME, XSD_DATE_TIME_STAMP);
        RL_DATATYPES = Arrays.asList(RDF_PLAIN_LITERAL, RDF_XML_LITERAL, RDFS_LITERAL, XSD_DECIMAL, XSD_INTEGER, XSD_NON_NEGATIVE_INTEGER, XSD_NON_POSITIVE_INTEGER, XSD_POSITIVE_INTEGER, XSD_NEGATIVE_INTEGER, XSD_LONG, XSD_INT, XSD_SHORT, XSD_BYTE, XSD_UNSIGNED_LONG, XSD_UNSIGNED_BYTE, XSD_FLOAT, XSD_DOUBLE, XSD_STRING, XSD_NORMALIZED_STRING, XSD_TOKEN, XSD_LANGUAGE, XSD_NAME, XSD_NCNAME, XSD_NMTOKEN, XSD_BOOLEAN, XSD_HEX_BINARY, XSD_BASE_64_BINARY, XSD_ANY_URI, XSD_DATE_TIME, XSD_DATE_TIME_STAMP);
        ALL_IRIS = OWLAPIStreamUtils.asMap(OWL2Datatype.stream(), HasIRI::getIRI);
    }

    public static enum WhiteSpaceNormalisation {
        PRESERVE{

            @Override
            public String getNormalisedString(String s) {
                return s;
            }
        }
        ,
        REPLACE{

            @Override
            public String getNormalisedString(String s) {
                return s.replaceAll("\\t|\\n|\\r", " ");
            }
        }
        ,
        COLLAPSE{

            @Override
            public String getNormalisedString(String s) {
                return REPLACE.getNormalisedString(s).replaceAll("\\s+", " ").trim();
            }
        };


        public abstract String getNormalisedString(String var1);
    }

    public static enum Category {
        CAT_NUMBER("Number", OWLFacet.MIN_INCLUSIVE, OWLFacet.MAX_INCLUSIVE, OWLFacet.MIN_EXCLUSIVE, OWLFacet.MAX_EXCLUSIVE),
        CAT_STRING_WITH_LANGUAGE_TAG("String with a language tag", OWLFacet.MIN_LENGTH, OWLFacet.MAX_LENGTH, OWLFacet.LENGTH, OWLFacet.PATTERN, OWLFacet.LANG_RANGE),
        CAT_STRING_WITHOUT_LANGUAGE_TAG("String without a language tag", OWLFacet.MIN_LENGTH, OWLFacet.MAX_LENGTH, OWLFacet.LENGTH, OWLFacet.PATTERN),
        CAT_BINARY("Binary data", OWLFacet.MIN_LENGTH, OWLFacet.MAX_LENGTH, OWLFacet.LENGTH),
        CAT_URI("URI", OWLFacet.MIN_LENGTH, OWLFacet.MAX_LENGTH, OWLFacet.PATTERN),
        CAT_TIME("Time instant", OWLFacet.MIN_INCLUSIVE, OWLFacet.MAX_INCLUSIVE, OWLFacet.MIN_EXCLUSIVE, OWLFacet.MAX_EXCLUSIVE),
        CAT_BOOLEAN("Boolean value", new OWLFacet[0]),
        CAT_UNIVERSAL("Universal literal", new OWLFacet[0]);

        private final String name;
        private final Set<OWLFacet> facets;

        private Category(String name, OWLFacet ... facets) {
            this.name = name;
            this.facets = CollectionFactory.createSet(facets);
        }

        public String getName() {
            return this.name;
        }

        public Set<OWLFacet> getFacets() {
            return OWLAPIStreamUtils.asSet(this.facets());
        }

        public Stream<OWLFacet> facets() {
            return this.facets.stream();
        }
    }
}

