/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.atomicdecomposition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class Atom {
    private final Collection<OWLAxiom> axioms;
    @Nullable
    private List<OWLEntity> signature;
    @Nullable
    private Collection<OWLEntity> label;
    private final int hashcode;

    public Atom(Collection<OWLAxiom> axioms) {
        this.axioms = axioms;
        this.hashcode = this.axioms.hashCode();
    }

    public boolean contains(OWLAxiom ax) {
        return this.axioms.contains(ax);
    }

    private void initSignature() {
        if (this.signature == null) {
            this.signature = new ArrayList<OWLEntity>();
            this.axioms.forEach(ax -> OWLAPIStreamUtils.add((Collection)OWLAPIPreconditions.verifyNotNull(this.signature), ax.signature()));
        }
    }

    public Collection<OWLEntity> getSignature() {
        this.initSignature();
        return OWLAPIPreconditions.verifyNotNull(this.signature);
    }

    public Collection<OWLAxiom> getAxioms() {
        return this.axioms;
    }

    @Nullable
    public Collection<OWLEntity> getLabel() {
        return this.label;
    }

    public void setLabel(Collection<OWLEntity> labelSignature) {
        this.label = labelSignature;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Atom) {
            return this.axioms.equals(((Atom)obj).axioms);
        }
        return false;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() {
        return this.axioms.toString();
    }
}

