/*
 * This file is part of the OWL API.
 *
 * The contents of this file are subject to the LGPL License, Version 3.0.
 *
 * Copyright (C) 2011, The University of Manchester
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses/.
 *
 *
 * Alternatively, the contents of this file may be used under the terms of the Apache License, Version 2.0
 * in which case, the provisions of the Apache License Version 2.0 are applicable instead of those above.
 *
 * Copyright 2011, University of Manchester
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;

import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubPropertyAxiom;

/** @author Matthew Horridge, The University Of Manchester, Bio-Health Informatics
 *         Group, Date: 26-Oct-2006
 * @param <P>
 *            property type */
public abstract class OWLSubPropertyAxiomImpl<P extends OWLPropertyExpression<?, ?>>
        extends OWLPropertyAxiomImpl implements OWLSubPropertyAxiom<P> {
    private static final long serialVersionUID = 30406L;
    private final P subProperty;
    private final P superProperty;

    /** @param subProperty
     *            subProperty
     * @param superProperty
     *            superProperty
     * @param annotations
     *            annotations */
    public OWLSubPropertyAxiomImpl(P subProperty, P superProperty,
            Collection<? extends OWLAnnotation> annotations) {
        super(annotations);
        this.subProperty = subProperty;
        this.superProperty = superProperty;
    }

    @Override
    public P getSubProperty() {
        return subProperty;
    }

    @Override
    public P getSuperProperty() {
        return superProperty;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLSubPropertyAxiom)) {
                return false;
            }
            OWLSubPropertyAxiom<?> other = (OWLSubPropertyAxiom<?>) obj;
            return other.getSubProperty().equals(subProperty)
                    && other.getSuperProperty().equals(superProperty);
        }
        return false;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLSubPropertyAxiom<?> other = (OWLSubPropertyAxiom<?>) object;
        int diff = subProperty.compareTo(other.getSubProperty());
        if (diff != 0) {
            return diff;
        }
        return superProperty.compareTo(other.getSuperProperty());
    }
}
