/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collections;
import java.util.Set;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpressionVisitor;
import org.semanticweb.owlapi.model.OWLPropertyExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubPropertyAxiom;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.owl.owlapi.ImplUtils;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyExpressionImpl;

public class OWLObjectPropertyImpl
extends OWLObjectPropertyExpressionImpl
implements OWLObjectProperty {
    private static final long serialVersionUID = 30406L;
    private final IRI iri;
    private final boolean builtin;

    public OWLObjectPropertyImpl(IRI iri) {
        this.iri = iri;
        this.builtin = iri.equals((Object)OWLRDFVocabulary.OWL_TOP_OBJECT_PROPERTY.getIRI()) || iri.equals((Object)OWLRDFVocabulary.OWL_BOTTOM_OBJECT_PROPERTY.getIRI());
    }

    @Override
    public boolean isTopEntity() {
        return this.isOWLTopObjectProperty();
    }

    @Override
    public boolean isBottomEntity() {
        return this.isOWLBottomObjectProperty();
    }

    public EntityType<?> getEntityType() {
        return EntityType.OBJECT_PROPERTY;
    }

    public <E extends OWLEntity> E getOWLEntity(EntityType<E> entityType) {
        return OWLObjectPropertyImpl.getOWLEntity(entityType, this.iri);
    }

    public boolean isType(EntityType<?> entityType) {
        return this.getEntityType().equals(entityType);
    }

    public String toStringID() {
        return this.iri.toString();
    }

    public IRI getIRI() {
        return this.iri;
    }

    public boolean isBuiltIn() {
        return this.builtin;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLObjectProperty)) {
                return false;
            }
            IRI otherIRI = ((OWLObjectProperty)obj).getIRI();
            return otherIRI.equals((Object)this.iri);
        }
        return false;
    }

    public void accept(OWLEntityVisitor visitor) {
        visitor.visit((OWLObjectProperty)this);
    }

    public void accept(OWLPropertyExpressionVisitor visitor) {
        visitor.visit((OWLObjectProperty)this);
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLObjectProperty)this);
    }

    public void accept(OWLNamedObjectVisitor visitor) {
        visitor.visit((OWLObjectProperty)this);
    }

    public <O> O accept(OWLEntityVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLObjectProperty)this);
    }

    public <O> O accept(OWLPropertyExpressionVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLObjectProperty)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLObjectProperty)this);
    }

    public boolean isAnonymous() {
        return false;
    }

    public OWLObjectProperty asOWLObjectProperty() {
        return this;
    }

    @Override
    protected Set<? extends OWLSubPropertyAxiom<OWLObjectPropertyExpression>> getSubPropertyAxiomsForRHS(OWLOntology ont) {
        return ont.getObjectSubPropertyAxiomsForSuperProperty((OWLObjectPropertyExpression)this);
    }

    public Set<OWLAnnotation> getAnnotations(OWLOntology ontology) {
        return ImplUtils.getAnnotations((OWLEntity)this, Collections.singleton(ontology));
    }

    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(OWLOntology ontology) {
        return ImplUtils.getAnnotationAxioms((OWLEntity)this, Collections.singleton(ontology));
    }

    public Set<OWLAnnotation> getAnnotations(OWLOntology ontology, OWLAnnotationProperty annotationProperty) {
        return ImplUtils.getAnnotations((OWLEntity)this, annotationProperty, Collections.singleton(ontology));
    }

    public OWLDataProperty asOWLDataProperty() {
        throw new OWLRuntimeException("Not a data property!");
    }

    public OWLDatatype asOWLDatatype() {
        throw new OWLRuntimeException("Not a data type!");
    }

    public OWLNamedIndividual asOWLNamedIndividual() {
        throw new OWLRuntimeException("Not an individual!");
    }

    public OWLClass asOWLClass() {
        throw new OWLRuntimeException("Not an OWLClass!");
    }

    public boolean isOWLClass() {
        return false;
    }

    public boolean isOWLDataProperty() {
        return false;
    }

    public boolean isOWLDatatype() {
        return false;
    }

    public boolean isOWLNamedIndividual() {
        return false;
    }

    public boolean isOWLObjectProperty() {
        return true;
    }

    public OWLAnnotationProperty asOWLAnnotationProperty() {
        throw new OWLRuntimeException("Not an annotation property");
    }

    public boolean isOWLAnnotationProperty() {
        return false;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        return this.iri.compareTo((OWLObject)((OWLObjectProperty)object).getIRI());
    }

    public boolean isOWLTopObjectProperty() {
        return this.iri.equals((Object)OWLRDFVocabulary.OWL_TOP_OBJECT_PROPERTY.getIRI());
    }

    public boolean isOWLBottomObjectProperty() {
        return this.iri.equals((Object)OWLRDFVocabulary.OWL_BOTTOM_OBJECT_PROPERTY.getIRI());
    }

    public boolean isOWLTopDataProperty() {
        return false;
    }

    public boolean isOWLBottomDataProperty() {
        return false;
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLOntology ontology) {
        return ontology.getReferencingAxioms((OWLEntity)this);
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLOntology ontology, boolean includeImports) {
        return ontology.getReferencingAxioms((OWLEntity)this, includeImports);
    }
}

