/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.semanticweb.owlapi.io.OWLOntologyCreationIOException;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParser;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.OWLParserFactory;
import org.semanticweb.owlapi.io.OWLParserFactoryRegistry;
import org.semanticweb.owlapi.io.UnparsableOntologyException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.UnloadableImportException;
import uk.ac.manchester.cs.owl.owlapi.AbstractInMemOWLOntologyFactory;

public class ParsableOWLOntologyFactory
extends AbstractInMemOWLOntologyFactory {
    private static final long serialVersionUID = 30406L;
    private static final Logger logger = Logger.getLogger(ParsableOWLOntologyFactory.class.getName());
    private final Set<String> parsableSchemes = new HashSet<String>();

    public ParsableOWLOntologyFactory() {
        this.parsableSchemes.add("http");
        this.parsableSchemes.add("https");
        this.parsableSchemes.add("file");
        this.parsableSchemes.add("ftp");
    }

    public List<OWLParser> getParsers() {
        ArrayList<OWLParser> parsers = new ArrayList<OWLParser>();
        List factories = OWLParserFactoryRegistry.getInstance().getParserFactories();
        for (OWLParserFactory factory : factories) {
            OWLParser parser = factory.createParser(this.getOWLOntologyManager());
            parser.setOWLOntologyManager(this.getOWLOntologyManager());
            parsers.add(parser);
        }
        return new ArrayList<OWLParser>(parsers);
    }

    @Override
    public boolean canCreateFromDocumentIRI(IRI documentIRI) {
        return false;
    }

    @Deprecated
    public OWLOntology createOWLOntology(URI ontologyURI, URI physicalURI) {
        throw new OWLRuntimeException((Throwable)new UnsupportedOperationException("Cannot create new empty ontologies!"));
    }

    public boolean canLoad(OWLOntologyDocumentSource documentSource) {
        if (documentSource.isReaderAvailable()) {
            return true;
        }
        if (documentSource.isInputStreamAvailable()) {
            return true;
        }
        if (this.parsableSchemes.contains(documentSource.getDocumentIRI().getScheme())) {
            return true;
        }
        try {
            InputStream is = documentSource.getDocumentIRI().toURI().toURL().openStream();
            is.close();
            return true;
        }
        catch (UnknownHostException e) {
            logger.info("Unknown host: " + e.getMessage());
        }
        catch (MalformedURLException e) {
            logger.info("Malformed URL: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            logger.info("File not found: " + e.getMessage());
        }
        catch (IOException e) {
            logger.info("IO Exception: " + e.getMessage());
        }
        return false;
    }

    public OWLOntology loadOWLOntology(OWLOntologyDocumentSource documentSource, OWLOntologyFactory.OWLOntologyCreationHandler mediator, OWLOntologyLoaderConfiguration configuration) throws OWLOntologyCreationException {
        LinkedHashMap<OWLParser, OWLParserException> exceptions = new LinkedHashMap<OWLParser, OWLParserException>();
        OWLOntology existingOntology = null;
        IRI iri = documentSource.getDocumentIRI();
        if (this.getOWLOntologyManager().contains(iri)) {
            existingOntology = this.getOWLOntologyManager().getOntology(iri);
        }
        OWLOntologyID ontologyID = new OWLOntologyID();
        OWLOntology ont = super.createOWLOntology(ontologyID, documentSource.getDocumentIRI(), mediator);
        for (OWLParser parser : this.getParsers()) {
            try {
                if (existingOntology == null && !ont.isEmpty()) {
                    this.getOWLOntologyManager().removeOntology(ont);
                    ont = super.createOWLOntology(ontologyID, documentSource.getDocumentIRI(), mediator);
                }
                OWLOntologyFormat format = parser.parse(documentSource, ont, configuration);
                mediator.setOntologyFormat(ont, format);
                return ont;
            }
            catch (IOException e) {
                this.getOWLOntologyManager().removeOntology(ont);
                throw new OWLOntologyCreationIOException(e);
            }
            catch (UnloadableImportException e) {
                this.getOWLOntologyManager().removeOntology(ont);
                throw e;
            }
            catch (OWLParserException e) {
                exceptions.put(parser, e);
            }
            catch (RuntimeException e) {
                this.getOWLOntologyManager().removeOntology(ont);
                throw e;
            }
        }
        if (existingOntology == null) {
            this.getOWLOntologyManager().removeOntology(ont);
        }
        throw new UnparsableOntologyException(documentSource.getDocumentIRI(), exceptions, configuration);
    }

    public OWLOntology loadOWLOntology(OWLOntologyDocumentSource documentSource, OWLOntologyFactory.OWLOntologyCreationHandler mediator) throws OWLOntologyCreationException {
        return this.loadOWLOntology(documentSource, mediator, new OWLOntologyLoaderConfiguration());
    }
}

