/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;
import org.semanticweb.owlapi.util.CollectionFactory;

public abstract class DefaultNodeSet<E extends OWLObject>
implements NodeSet<E> {
    private final Set<Node<E>> nodes = new HashSet<Node<E>>();

    public DefaultNodeSet() {
    }

    public DefaultNodeSet(E entity) {
        this.nodes.add(this.getNode(entity));
    }

    public DefaultNodeSet(Node<E> node) {
        this.nodes.add(node);
    }

    public DefaultNodeSet(Set<Node<E>> nodes) {
        this.nodes.addAll(nodes);
    }

    public Set<Node<E>> getNodes() {
        return CollectionFactory.getCopyOnRequestSetFromMutableCollection(this.nodes);
    }

    public void addEntity(E entity) {
        if (entity == null) {
            throw new NullPointerException("entity cannot be null");
        }
        this.addNode(this.getNode(entity));
    }

    public void addNode(Node<E> node) {
        if (node == null) {
            throw new NullPointerException("Cannot add null to a NodeSet");
        }
        this.nodes.add(node);
    }

    public void addAllNodes(Collection<Node<E>> nodeset) {
        for (Node<E> node : nodeset) {
            if (node == null) continue;
            this.nodes.add(node);
        }
    }

    public void addSameEntities(Set<E> entities) {
        this.nodes.add(this.getNode(entities));
    }

    public void addDifferentEntities(Set<E> entities) {
        for (OWLObject e : entities) {
            this.addNode(this.getNode(e));
        }
    }

    protected abstract DefaultNode<E> getNode(E var1);

    protected abstract DefaultNode<E> getNode(Set<E> var1);

    public Set<E> getFlattened() {
        HashSet result = new HashSet();
        for (Node<E> node : this.nodes) {
            result.addAll(node.getEntities());
        }
        return result;
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public boolean containsEntity(E e) {
        for (Node<E> node : this.nodes) {
            if (!node.contains(e)) continue;
            return true;
        }
        return false;
    }

    public boolean isSingleton() {
        return this.nodes.size() == 1;
    }

    public boolean isTopSingleton() {
        return this.isSingleton() && this.nodes.iterator().next().isTopNode();
    }

    public boolean isBottomSingleton() {
        return this.isSingleton() && this.nodes.iterator().next().isBottomNode();
    }

    public Iterator<Node<E>> iterator() {
        return this.nodes.iterator();
    }

    public String toString() {
        return "Nodeset" + this.nodes.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NodeSet)) {
            return false;
        }
        NodeSet other = (NodeSet)obj;
        return this.nodes.equals(other.getNodes());
    }

    public int hashCode() {
        return this.nodes.hashCode();
    }
}

