/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.owl.owlapi.ImplUtils;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

public class OWLAnnotationPropertyImpl
extends OWLObjectImpl
implements OWLAnnotationProperty {
    private static final long serialVersionUID = 30406L;
    private final IRI iri;

    public OWLAnnotationPropertyImpl(IRI i) {
        this.iri = i;
    }

    public IRI getIRI() {
        return this.iri;
    }

    public EntityType<?> getEntityType() {
        return EntityType.ANNOTATION_PROPERTY;
    }

    public <E extends OWLEntity> E getOWLEntity(EntityType<E> entityType) {
        return OWLAnnotationPropertyImpl.getOWLEntity(entityType, this.getIRI());
    }

    public boolean isType(EntityType<?> entityType) {
        return this.getEntityType().equals(entityType);
    }

    public String toStringID() {
        return this.iri.toString();
    }

    public boolean isDeprecated() {
        return this.iri.equals((Object)OWLRDFVocabulary.OWL_DEPRECATED.getIRI());
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        return this.iri.compareTo((OWLObject)((OWLAnnotationProperty)object).getIRI());
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLAnnotationProperty)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLAnnotationProperty)this);
    }

    public boolean isComment() {
        return this.iri.equals((Object)OWLRDFVocabulary.RDFS_COMMENT.getIRI());
    }

    public boolean isLabel() {
        return this.iri.equals((Object)OWLRDFVocabulary.RDFS_LABEL.getIRI());
    }

    public void accept(OWLEntityVisitor visitor) {
        visitor.visit((OWLAnnotationProperty)this);
    }

    public <O> O accept(OWLEntityVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLAnnotationProperty)this);
    }

    public OWLClass asOWLClass() {
        throw new OWLRuntimeException("Not OWLClass");
    }

    public OWLDataProperty asOWLDataProperty() {
        throw new OWLRuntimeException("Not OWLDataProperty");
    }

    public OWLDatatype asOWLDatatype() {
        throw new OWLRuntimeException("Not OWLDatatype");
    }

    public OWLNamedIndividual asOWLNamedIndividual() {
        throw new OWLRuntimeException("Not OWLIndividual");
    }

    public OWLObjectProperty asOWLObjectProperty() {
        throw new OWLRuntimeException("Not OWLObjectProperty");
    }

    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(OWLOntology ontology) {
        return ImplUtils.getAnnotationAxioms((OWLEntity)this, Collections.singleton(ontology));
    }

    public Set<OWLAnnotation> getAnnotations(OWLOntology ontology) {
        return ImplUtils.getAnnotations((OWLEntity)this, Collections.singleton(ontology));
    }

    public Set<OWLAnnotation> getAnnotations(OWLOntology ontology, OWLAnnotationProperty annotationProperty) {
        return ImplUtils.getAnnotations((OWLEntity)this, annotationProperty, Collections.singleton(ontology));
    }

    public boolean isBuiltIn() {
        return OWLRDFVocabulary.BUILT_IN_ANNOTATION_PROPERTY_IRIS.contains(this.getIRI());
    }

    public boolean isOWLClass() {
        return false;
    }

    public boolean isOWLDataProperty() {
        return false;
    }

    public boolean isOWLDatatype() {
        return false;
    }

    public boolean isOWLNamedIndividual() {
        return false;
    }

    public boolean isOWLObjectProperty() {
        return false;
    }

    public OWLAnnotationProperty asOWLAnnotationProperty() {
        return this;
    }

    public boolean isOWLAnnotationProperty() {
        return true;
    }

    public void accept(OWLNamedObjectVisitor visitor) {
        visitor.visit((OWLAnnotationProperty)this);
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLOntology ontology) {
        return ontology.getReferencingAxioms((OWLEntity)this);
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLOntology ontology, boolean includeImports) {
        return ontology.getReferencingAxioms((OWLEntity)this, includeImports);
    }

    public Set<OWLAnnotationProperty> getSubProperties(OWLOntology ontology) {
        return this.getSubProperties(Collections.singleton(ontology));
    }

    public Set<OWLAnnotationProperty> getSubProperties(OWLOntology ontology, boolean includeImportsClosure) {
        if (includeImportsClosure) {
            return this.getSubProperties(ontology.getImportsClosure());
        }
        return this.getSubProperties(Collections.singleton(ontology));
    }

    public Set<OWLAnnotationProperty> getSubProperties(Set<OWLOntology> ontologies) {
        HashSet<OWLAnnotationProperty> result = new HashSet<OWLAnnotationProperty>();
        for (OWLOntology ont : ontologies) {
            for (OWLSubAnnotationPropertyOfAxiom ax : ont.getAxioms(AxiomType.SUB_ANNOTATION_PROPERTY_OF)) {
                if (!ax.getSuperProperty().equals(this)) continue;
                result.add(ax.getSubProperty());
            }
        }
        return result;
    }

    public Set<OWLAnnotationProperty> getSuperProperties(OWLOntology ontology) {
        return this.getSuperProperties(Collections.singleton(ontology));
    }

    public Set<OWLAnnotationProperty> getSuperProperties(OWLOntology ontology, boolean includeImportsClosure) {
        if (includeImportsClosure) {
            return this.getSuperProperties(ontology.getImportsClosure());
        }
        return this.getSuperProperties(Collections.singleton(ontology));
    }

    public Set<OWLAnnotationProperty> getSuperProperties(Set<OWLOntology> ontologies) {
        HashSet<OWLAnnotationProperty> result = new HashSet<OWLAnnotationProperty>();
        for (OWLOntology ont : ontologies) {
            for (OWLSubAnnotationPropertyOfAxiom ax : ont.getAxioms(AxiomType.SUB_ANNOTATION_PROPERTY_OF)) {
                if (!ax.getSubProperty().equals(this)) continue;
                result.add(ax.getSuperProperty());
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OWLAnnotationProperty)) {
            return false;
        }
        OWLAnnotationProperty other = (OWLAnnotationProperty)obj;
        return this.iri.equals((Object)other.getIRI());
    }
}

