/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.ClassExpressionType;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.owl.owlapi.ImplUtils;
import uk.ac.manchester.cs.owl.owlapi.OWLClassExpressionImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectComplementOfImpl;

public class OWLClassImpl
extends OWLClassExpressionImpl
implements OWLClass,
Serializable {
    private static final long serialVersionUID = 30406L;
    private final IRI iri;
    private final boolean isThing;
    private final boolean isNothing;

    public OWLClassImpl(IRI iri) {
        this.iri = iri;
        this.isThing = this.getIRI().equals((Object)OWLRDFVocabulary.OWL_THING.getIRI());
        this.isNothing = this.getIRI().equals((Object)OWLRDFVocabulary.OWL_NOTHING.getIRI());
    }

    @Override
    public boolean isTopEntity() {
        return this.isOWLThing();
    }

    @Override
    public boolean isBottomEntity() {
        return this.isOWLNothing();
    }

    public ClassExpressionType getClassExpressionType() {
        return ClassExpressionType.OWL_CLASS;
    }

    public OWLClassExpression getObjectComplementOf() {
        return new OWLObjectComplementOfImpl(this);
    }

    public EntityType<?> getEntityType() {
        return EntityType.CLASS;
    }

    public <E extends OWLEntity> E getOWLEntity(EntityType<E> entityType) {
        return OWLClassImpl.getOWLEntity(entityType, this.getIRI());
    }

    public boolean isType(EntityType<?> entityType) {
        return this.getEntityType().equals(entityType);
    }

    public String toStringID() {
        return this.iri.toString();
    }

    public IRI getIRI() {
        return this.iri;
    }

    public boolean isBuiltIn() {
        return this.isOWLThing() || this.isOWLNothing();
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLOntology ontology) {
        return ontology.getReferencingAxioms((OWLEntity)this);
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLOntology ontology, boolean includeImports) {
        return ontology.getReferencingAxioms((OWLEntity)this, includeImports);
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isClassExpressionLiteral() {
        return true;
    }

    public OWLClass asOWLClass() {
        return this;
    }

    public boolean isOWLThing() {
        return this.isThing;
    }

    public boolean isOWLNothing() {
        return this.isNothing;
    }

    public OWLClassExpression getNNF() {
        return this;
    }

    public Set<OWLClassExpression> asConjunctSet() {
        return Collections.singleton(this);
    }

    public boolean containsConjunct(OWLClassExpression ce) {
        return ce.equals(this);
    }

    public Set<OWLClassExpression> asDisjunctSet() {
        return Collections.singleton(this);
    }

    public OWLClassExpression getComplementNNF() {
        return new OWLObjectComplementOfImpl(this);
    }

    @Deprecated
    public Set<OWLSubClassOfAxiom> getSubClassAxioms(OWLOntology ontology) {
        return ontology.getSubClassAxiomsForSubClass((OWLClass)this);
    }

    @Deprecated
    public Set<OWLEquivalentClassesAxiom> getEquivalentClassesAxioms(OWLOntology ontology) {
        return ontology.getEquivalentClassesAxioms((OWLClass)this);
    }

    @Deprecated
    public Set<OWLDisjointClassesAxiom> getDisjointClassesAxioms(OWLOntology ontology) {
        return ontology.getDisjointClassesAxioms((OWLClass)this);
    }

    @Deprecated
    public Set<OWLDisjointUnionAxiom> getDisjointUnionAxioms(OWLOntology ontology) {
        return ontology.getDisjointUnionAxioms((OWLClass)this);
    }

    public Set<OWLClassExpression> getSuperClasses(OWLOntology ontology) {
        TreeSet<OWLClassExpression> result = new TreeSet<OWLClassExpression>();
        for (OWLSubClassOfAxiom axiom : this.getSubClassAxioms(ontology)) {
            result.add(axiom.getSuperClass());
        }
        return result;
    }

    public Set<OWLClassExpression> getSuperClasses(Set<OWLOntology> ontologies) {
        TreeSet<OWLClassExpression> result = new TreeSet<OWLClassExpression>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getSuperClasses(ont));
        }
        return result;
    }

    public Set<OWLClassExpression> getSubClasses(OWLOntology ontology) {
        TreeSet<OWLClassExpression> result = new TreeSet<OWLClassExpression>();
        for (OWLSubClassOfAxiom axiom : ontology.getSubClassAxiomsForSuperClass((OWLClass)this)) {
            result.add(axiom.getSubClass());
        }
        return result;
    }

    public Set<OWLClassExpression> getSubClasses(Set<OWLOntology> ontologies) {
        TreeSet<OWLClassExpression> result = new TreeSet<OWLClassExpression>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getSubClasses(ont));
        }
        return result;
    }

    public Set<OWLClassExpression> getEquivalentClasses(OWLOntology ontology) {
        TreeSet<OWLClassExpression> result = new TreeSet<OWLClassExpression>();
        for (OWLEquivalentClassesAxiom axiom : this.getEquivalentClassesAxioms(ontology)) {
            result.addAll(axiom.getClassExpressions());
        }
        result.remove(this);
        return result;
    }

    public Set<OWLClassExpression> getEquivalentClasses(Set<OWLOntology> ontologies) {
        TreeSet<OWLClassExpression> result = new TreeSet<OWLClassExpression>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getEquivalentClasses(ont));
        }
        return result;
    }

    public Set<OWLClassExpression> getDisjointClasses(OWLOntology ontology) {
        TreeSet<OWLClassExpression> result = new TreeSet<OWLClassExpression>();
        for (OWLDisjointClassesAxiom axiom : this.getDisjointClassesAxioms(ontology)) {
            result.addAll(axiom.getClassExpressions());
        }
        result.remove(this);
        return result;
    }

    public Set<OWLClassExpression> getDisjointClasses(Set<OWLOntology> ontologies) {
        TreeSet<OWLClassExpression> result = new TreeSet<OWLClassExpression>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getDisjointClasses(ont));
        }
        return result;
    }

    public Set<OWLIndividual> getIndividuals(OWLOntology ontology) {
        TreeSet<OWLIndividual> result = new TreeSet<OWLIndividual>();
        for (OWLClassAssertionAxiom ax : ontology.getClassAssertionAxioms((OWLClassExpression)this)) {
            result.add(ax.getIndividual());
        }
        return result;
    }

    public Set<OWLIndividual> getIndividuals(Set<OWLOntology> ontologies) {
        TreeSet<OWLIndividual> result = new TreeSet<OWLIndividual>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getIndividuals(ont));
        }
        return result;
    }

    public Set<OWLAnnotation> getAnnotations(OWLOntology ontology) {
        return ImplUtils.getAnnotations((OWLEntity)this, Collections.singleton(ontology));
    }

    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(OWLOntology ontology) {
        return ImplUtils.getAnnotationAxioms((OWLEntity)this, Collections.singleton(ontology));
    }

    public Set<OWLAnnotation> getAnnotations(OWLOntology ontology, OWLAnnotationProperty annotationProperty) {
        return ImplUtils.getAnnotations((OWLEntity)this, annotationProperty, Collections.singleton(ontology));
    }

    public boolean isDefined(OWLOntology ontology) {
        return !ontology.getEquivalentClassesAxioms((OWLClass)this).isEmpty();
    }

    public boolean isDefined(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isDefined(ont)) continue;
            return true;
        }
        return false;
    }

    public OWLDataProperty asOWLDataProperty() {
        throw new OWLRuntimeException("Not a data property!");
    }

    public OWLDatatype asOWLDatatype() {
        throw new OWLRuntimeException("Not a data type!");
    }

    public OWLNamedIndividual asOWLNamedIndividual() {
        throw new OWLRuntimeException("Not an individual!");
    }

    public OWLObjectProperty asOWLObjectProperty() {
        throw new OWLRuntimeException("Not an object property");
    }

    public boolean isOWLClass() {
        return true;
    }

    public boolean isOWLDataProperty() {
        return false;
    }

    public boolean isOWLDatatype() {
        return false;
    }

    public boolean isOWLNamedIndividual() {
        return false;
    }

    public boolean isOWLObjectProperty() {
        return false;
    }

    public OWLAnnotationProperty asOWLAnnotationProperty() {
        throw new OWLRuntimeException("Not an annotation property");
    }

    public boolean isOWLAnnotationProperty() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLClass)) {
                return false;
            }
            IRI otherIRI = ((OWLClass)obj).getIRI();
            return otherIRI.equals((Object)this.iri);
        }
        return false;
    }

    public void accept(OWLClassExpressionVisitor visitor) {
        visitor.visit((OWLClass)this);
    }

    public void accept(OWLEntityVisitor visitor) {
        visitor.visit((OWLClass)this);
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLClass)this);
    }

    public void accept(OWLNamedObjectVisitor visitor) {
        visitor.visit((OWLClass)this);
    }

    public <O> O accept(OWLEntityVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLClass)this);
    }

    public <O> O accept(OWLClassExpressionVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLClass)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLClass)this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLClass other = (OWLClass)object;
        return this.iri.compareTo((OWLObject)other.getIRI());
    }
}

