/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.lang.ref.WeakReference;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.util.WeakIndexCache;
import uk.ac.manchester.cs.owl.owlapi.InternalsNoCache;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLNamedIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;

public class OWLDataFactoryInternalsImpl
extends InternalsNoCache {
    private static final long serialVersionUID = 30406L;
    private final BuildableWeakIndexCache<OWLClass> classesByURI = this.buildCache();
    private final BuildableWeakIndexCache<OWLObjectProperty> objectPropertiesByURI = this.buildCache();
    private final BuildableWeakIndexCache<OWLDataProperty> dataPropertiesByURI = this.buildCache();
    private final BuildableWeakIndexCache<OWLDatatype> datatypesByURI = this.buildCache();
    private final BuildableWeakIndexCache<OWLNamedIndividual> individualsByURI = this.buildCache();
    private final BuildableWeakIndexCache<OWLAnnotationProperty> annotationPropertiesByURI = this.buildCache();

    protected <V extends OWLEntity> BuildableWeakIndexCache<V> buildCache() {
        return new BuildableWeakIndexCache();
    }

    public OWLDataFactoryInternalsImpl(boolean useCompression) {
        super(useCompression);
    }

    @Override
    public OWLClass getOWLClass(IRI iri) {
        return this.classesByURI.cache(iri, Buildable.OWLCLASS);
    }

    @Override
    public void purge() {
        this.classesByURI.clear();
        this.objectPropertiesByURI.clear();
        this.dataPropertiesByURI.clear();
        this.datatypesByURI.clear();
        this.individualsByURI.clear();
        this.annotationPropertiesByURI.clear();
    }

    @Override
    public OWLObjectProperty getOWLObjectProperty(IRI iri) {
        return this.objectPropertiesByURI.cache(iri, Buildable.OWLOBJECTPROPERTY);
    }

    @Override
    public OWLDataProperty getOWLDataProperty(IRI iri) {
        return this.dataPropertiesByURI.cache(iri, Buildable.OWLDATAPROPERTY);
    }

    @Override
    public OWLNamedIndividual getOWLNamedIndividual(IRI iri) {
        return this.individualsByURI.cache(iri, Buildable.OWLNAMEDINDIVIDUAL);
    }

    @Override
    public OWLDatatype getOWLDatatype(IRI iri) {
        return this.datatypesByURI.cache(iri, Buildable.OWLDATATYPE);
    }

    @Override
    public OWLAnnotationProperty getOWLAnnotationProperty(IRI iri) {
        return this.annotationPropertiesByURI.cache(iri, Buildable.OWLANNOTATIONPROPERTY);
    }

    protected static enum Buildable {
        OWLCLASS{

            OWLClass build(IRI iri) {
                return new OWLClassImpl(iri);
            }
        }
        ,
        OWLOBJECTPROPERTY{

            OWLObjectProperty build(IRI iri) {
                return new OWLObjectPropertyImpl(iri);
            }
        }
        ,
        OWLDATAPROPERTY{

            OWLDataProperty build(IRI iri) {
                return new OWLDataPropertyImpl(iri);
            }
        }
        ,
        OWLNAMEDINDIVIDUAL{

            OWLNamedIndividual build(IRI iri) {
                return new OWLNamedIndividualImpl(iri);
            }
        }
        ,
        OWLDATATYPE{

            OWLDatatype build(IRI iri) {
                return new OWLDatatypeImpl(iri);
            }
        }
        ,
        OWLANNOTATIONPROPERTY{

            OWLAnnotationProperty build(IRI iri) {
                return new OWLAnnotationPropertyImpl(iri);
            }
        };


        abstract <K extends OWLEntity> K build(IRI var1);
    }

    protected class BuildableWeakIndexCache<V extends OWLEntity>
    extends WeakIndexCache<IRI, V> {
        private static final long serialVersionUID = 30406L;

        protected BuildableWeakIndexCache() {
        }

        public V cache(IRI s, Buildable v) {
            OWLEntity toReturn;
            WeakReference w = (WeakReference)this.prefixCache.get(s);
            if (w != null && (toReturn = (OWLEntity)w.get()) != null) {
                return (V)toReturn;
            }
            Object value = v.build(s);
            this.prefixCache.put(s, new WeakReference(value));
            return (V)value;
        }
    }
}

