/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;
import uk.ac.manchester.cs.owl.owlapi.OWLNaryClassAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubClassOfAxiomImpl;

public class OWLEquivalentClassesAxiomImpl
extends OWLNaryClassAxiomImpl
implements OWLEquivalentClassesAxiom,
Serializable {
    private static final long serialVersionUID = 30406L;
    private transient WeakReference<Set<OWLClass>> namedClasses = null;

    public OWLEquivalentClassesAxiomImpl(Set<? extends OWLClassExpression> classExpressions, Collection<? extends OWLAnnotation> annotations) {
        super(classExpressions, annotations);
    }

    public OWLEquivalentClassesAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLEquivalentClassesAxiomImpl(this.getClassExpressions(), NO_ANNOTATIONS);
    }

    public OWLEquivalentClassesAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return new OWLEquivalentClassesAxiomImpl(this.getClassExpressions(), this.mergeAnnos(annotations));
    }

    public Set<OWLEquivalentClassesAxiom> asPairwiseAxioms() {
        ArrayList<OWLClassExpression> classExpressions = new ArrayList<OWLClassExpression>(this.getClassExpressions());
        HashSet<OWLEquivalentClassesAxiom> result = new HashSet<OWLEquivalentClassesAxiom>();
        for (int i = 0; i < classExpressions.size() - 1; ++i) {
            OWLClassExpression ceI = (OWLClassExpression)classExpressions.get(i);
            OWLClassExpression ceJ = (OWLClassExpression)classExpressions.get(i + 1);
            result.add(new OWLEquivalentClassesAxiomImpl(new HashSet<OWLClassExpression>(Arrays.asList(ceI, ceJ)), NO_ANNOTATIONS));
        }
        return result;
    }

    public boolean containsNamedEquivalentClass() {
        return !this.getNamedClasses().isEmpty();
    }

    public boolean containsOWLNothing() {
        for (OWLClassExpression desc : this.getClassExpressions()) {
            if (!desc.isOWLNothing()) continue;
            return true;
        }
        return false;
    }

    public boolean containsOWLThing() {
        for (OWLClassExpression desc : this.getClassExpressions()) {
            if (!desc.isOWLThing()) continue;
            return true;
        }
        return false;
    }

    public Set<OWLClass> getNamedClasses() {
        Set toReturn = null;
        if (this.namedClasses != null) {
            toReturn = (Set)this.namedClasses.get();
        }
        if (toReturn == null) {
            HashSet<OWLClass> clses = new HashSet<OWLClass>(1);
            for (OWLClassExpression desc : this.getClassExpressions()) {
                if (desc.isAnonymous() || desc.isOWLNothing() || desc.isOWLThing()) continue;
                clses.add(desc.asOWLClass());
            }
            toReturn = CollectionFactory.getCopyOnRequestSetFromImmutableCollection(clses);
            this.namedClasses = new WeakReference<Set>(toReturn);
        }
        return toReturn;
    }

    public Set<OWLSubClassOfAxiom> asOWLSubClassOfAxioms() {
        HashSet<OWLSubClassOfAxiom> result = new HashSet<OWLSubClassOfAxiom>();
        ArrayList<OWLClassExpression> classExpressions = new ArrayList<OWLClassExpression>(this.getClassExpressions());
        for (int i = 0; i < classExpressions.size(); ++i) {
            for (int j = 0; j < classExpressions.size(); ++j) {
                if (i == j) continue;
                result.add(new OWLSubClassOfAxiomImpl((OWLClassExpression)classExpressions.get(i), (OWLClassExpression)classExpressions.get(j), NO_ANNOTATIONS));
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof OWLEquivalentClassesAxiom;
    }

    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit((OWLEquivalentClassesAxiom)this);
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLEquivalentClassesAxiom)this);
    }

    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLEquivalentClassesAxiom)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLEquivalentClassesAxiom)this);
    }

    public AxiomType<?> getAxiomType() {
        return AxiomType.EQUIVALENT_CLASSES;
    }
}

