/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.owl.owlapi.OWL2DatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

public class OWLLiteralImplBoolean
extends OWLObjectImpl
implements OWLLiteral {
    private static final long serialVersionUID = 30406L;
    private final boolean literal;
    private final OWLDatatype datatype = OWL2DatatypeImpl.getDatatype(OWL2Datatype.XSD_BOOLEAN);
    private final int hashcode;

    public OWLLiteralImplBoolean(boolean literal) {
        this.literal = literal;
        this.hashcode = this.getHashCode();
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    private int getHashCode() {
        int hashCode = 277;
        hashCode = hashCode * 37 + this.getDatatype().hashCode();
        hashCode = hashCode * 37 + (this.literal ? 65536 : 0);
        return hashCode;
    }

    public String getLiteral() {
        return Boolean.toString(this.literal);
    }

    public boolean isRDFPlainLiteral() {
        return false;
    }

    public boolean hasLang() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public int parseInteger() throws NumberFormatException {
        throw new NumberFormatException("this literal is not an integer but a boolean");
    }

    public boolean isBoolean() {
        return true;
    }

    public boolean parseBoolean() throws NumberFormatException {
        return this.literal;
    }

    public boolean isDouble() {
        return false;
    }

    public double parseDouble() throws NumberFormatException {
        throw new NumberFormatException("this literal is not a double but a boolean");
    }

    public boolean isFloat() {
        return false;
    }

    public float parseFloat() throws NumberFormatException {
        throw new NumberFormatException("this literal is not a float but a boolean");
    }

    public String getLang() {
        return "";
    }

    public boolean hasLang(String l) {
        return false;
    }

    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (obj instanceof OWLLiteralImplBoolean) {
                OWLLiteralImplBoolean other = (OWLLiteralImplBoolean)obj;
                return this.literal == other.literal && this.datatype.equals(other.getDatatype());
            }
            if (obj instanceof OWLLiteral) {
                return this.datatype.equals(((OWLLiteral)obj).getDatatype()) && this.getLiteral().equals(((OWLLiteral)obj).getLiteral());
            }
        }
        return false;
    }

    public void accept(OWLDataVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLLiteral other = (OWLLiteral)object;
        int diff = this.getLiteral().compareTo(other.getLiteral());
        if (diff != 0) {
            return diff;
        }
        int compareTo = this.datatype.compareTo((Object)other.getDatatype());
        if (compareTo != 0) {
            return compareTo;
        }
        return Boolean.compare(this.literal, other.parseBoolean());
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }
}

