/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.owl.owlapi.OWL2DatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

public class OWLLiteralImplPlain
extends OWLObjectImpl
implements OWLLiteral {
    private static final long serialVersionUID = 30406L;
    private static final OWLDatatype RDF_PLAIN_LITERAL = OWL2DatatypeImpl.getDatatype(OWL2Datatype.RDF_PLAIN_LITERAL);
    private final String literal;
    private final String lang;
    private final int hashcode;

    public OWLLiteralImplPlain(String literal, String lang) {
        this.literal = literal;
        this.lang = lang == null || lang.length() == 0 ? "" : lang;
        this.hashcode = this.getHashCode();
    }

    public String getLiteral() {
        return this.literal;
    }

    public boolean hasLang() {
        return !this.lang.equals("");
    }

    public int parseInteger() throws NumberFormatException {
        return Integer.parseInt(this.getLiteral());
    }

    public boolean isRDFPlainLiteral() {
        return true;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean parseBoolean() {
        throw new OWLRuntimeException(this.getClass().getName() + " does not have a boolean value");
    }

    public double parseDouble() {
        throw new OWLRuntimeException(this.getClass().getName() + " does not have a double value");
    }

    public float parseFloat() {
        throw new OWLRuntimeException(this.getClass().getName() + " does not have a float value");
    }

    public String getLang() {
        return this.lang;
    }

    public boolean hasLang(String l) {
        if (l == null) {
            l = "";
        }
        return this.lang.equalsIgnoreCase(l.trim());
    }

    public OWLDatatype getDatatype() {
        return RDF_PLAIN_LITERAL;
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    private int getHashCode() {
        int hashCode = 277;
        hashCode = hashCode * 37 + this.getDatatype().hashCode();
        hashCode *= 37;
        try {
            hashCode = this.isInteger() ? (hashCode += this.parseInteger() * 65536) : (this.isDouble() ? (hashCode += (int)this.parseDouble() * 65536) : (this.isFloat() ? (hashCode += (int)this.parseFloat() * 65536) : (this.isBoolean() ? (hashCode += this.parseBoolean() ? 65536 : 0) : (hashCode += this.getLiteral().hashCode() * 65536))));
        }
        catch (NumberFormatException e) {
            hashCode += this.getLiteral().hashCode() * 65536;
        }
        if (this.hasLang()) {
            hashCode = hashCode * 37 + this.getLang().hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLLiteral)) {
                return false;
            }
            OWLLiteral other = (OWLLiteral)obj;
            if (other instanceof OWLLiteralImplPlain) {
                return this.literal.equals(((OWLLiteralImplPlain)other).literal) && this.lang.equals(other.getLang());
            }
            return this.getLiteral().equals(other.getLiteral()) && this.getDatatype().equals(other.getDatatype()) && this.lang.equals(other.getLang());
        }
        return false;
    }

    public void accept(OWLDataVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLLiteral other = (OWLLiteral)object;
        int diff = this.getLiteral().compareTo(other.getLiteral());
        if (diff != 0) {
            return diff;
        }
        diff = this.getDatatype().compareTo((Object)other.getDatatype());
        if (diff != 0) {
            return diff;
        }
        return this.lang.compareTo(other.getLang());
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }
}

