/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.owl.owlapi.OWL2DatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

public class OWLLiteralImplString
extends OWLObjectImpl
implements OWLLiteral {
    private static final long serialVersionUID = 30406L;
    private static final OWLDatatype XSD_STRING = OWL2DatatypeImpl.getDatatype(OWL2Datatype.XSD_STRING);
    private final String literal;

    public OWLLiteralImplString(String literal) {
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public boolean hasLang() {
        return false;
    }

    public int parseInteger() throws NumberFormatException {
        return Integer.parseInt(this.getLiteral());
    }

    public boolean isRDFPlainLiteral() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean parseBoolean() {
        throw new OWLRuntimeException(this.getClass().getName() + " does not have a boolean value");
    }

    public double parseDouble() {
        throw new OWLRuntimeException(this.getClass().getName() + " does not have a double value");
    }

    public float parseFloat() {
        throw new OWLRuntimeException(this.getClass().getName() + " does not have a float value");
    }

    public String getLang() {
        return "";
    }

    public boolean hasLang(String l) {
        return false;
    }

    public OWLDatatype getDatatype() {
        return XSD_STRING;
    }

    @Override
    public int hashCode() {
        return this.literal.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLLiteral)) {
                return false;
            }
            OWLLiteral other = (OWLLiteral)obj;
            return this.getLiteral().equals(other.getLiteral()) && this.getDatatype().equals(other.getDatatype()) && this.getLang().equals(other.getLang());
        }
        return false;
    }

    public void accept(OWLDataVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLLiteral other = (OWLLiteral)object;
        int diff = this.getLiteral().compareTo(other.getLiteral());
        if (diff != 0) {
            return diff;
        }
        diff = this.getDatatype().compareTo((Object)other.getDatatype());
        if (diff != 0) {
            return diff;
        }
        return this.getLang().compareTo(other.getLang());
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }
}

