/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import uk.ac.manchester.cs.owl.owlapi.OWLNaryIndividualAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectOneOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubClassOfAxiomImpl;

public class OWLSameIndividualAxiomImpl
extends OWLNaryIndividualAxiomImpl
implements OWLSameIndividualAxiom {
    private static final long serialVersionUID = 30406L;

    public OWLSameIndividualAxiomImpl(Set<? extends OWLIndividual> individuals, Set<? extends OWLAnnotation> annotations) {
        super(individuals, annotations);
    }

    public OWLSameIndividualAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLSameIndividualAxiomImpl(this.getIndividuals(), NO_ANNOTATIONS);
    }

    public OWLSameIndividualAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return new OWLSameIndividualAxiomImpl(this.getIndividuals(), this.mergeAnnos(annotations));
    }

    public Set<OWLSameIndividualAxiom> asPairwiseAxioms() {
        List<OWLIndividual> inds = this.getIndividualsAsList();
        HashSet<OWLSameIndividualAxiom> result = new HashSet<OWLSameIndividualAxiom>();
        for (int i = 0; i < inds.size() - 1; ++i) {
            OWLIndividual indI = inds.get(i);
            OWLIndividual indJ = inds.get(i + 1);
            result.add(new OWLSameIndividualAxiomImpl((Set<? extends OWLIndividual>)new HashSet<OWLIndividual>(Arrays.asList(indI, indJ)), NO_ANNOTATIONS));
        }
        return result;
    }

    public boolean containsAnonymousIndividuals() {
        for (OWLIndividual ind : this.getIndividuals()) {
            if (!ind.isAnonymous()) continue;
            return true;
        }
        return false;
    }

    public Set<OWLSubClassOfAxiom> asOWLSubClassOfAxioms() {
        ArrayList<OWLObjectOneOfImpl> nominalsList = new ArrayList<OWLObjectOneOfImpl>();
        for (OWLIndividual individual : this.getIndividuals()) {
            nominalsList.add(new OWLObjectOneOfImpl(Collections.singleton(individual)));
        }
        HashSet<OWLSubClassOfAxiom> result = new HashSet<OWLSubClassOfAxiom>();
        for (int i = 0; i < nominalsList.size() - 1; ++i) {
            OWLClassExpression ceI = (OWLClassExpression)nominalsList.get(i);
            OWLClassExpression ceJ = (OWLClassExpression)nominalsList.get(i + 1);
            result.add(new OWLSubClassOfAxiomImpl(ceI, ceJ, NO_ANNOTATIONS));
            result.add(new OWLSubClassOfAxiomImpl(ceJ, ceI, NO_ANNOTATIONS));
        }
        return result;
    }

    @Deprecated
    public Set<OWLSameIndividualAxiom> asPairwiseSameIndividualAxioms() {
        return this.asPairwiseAxioms();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof OWLSameIndividualAxiom;
    }

    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit((OWLSameIndividualAxiom)this);
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLSameIndividualAxiom)this);
    }

    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLSameIndividualAxiom)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLSameIndividualAxiom)this);
    }

    public AxiomType<?> getAxiomType() {
        return AxiomType.SAME_INDIVIDUAL;
    }
}

