/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo12.parser;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.coode.owlapi.obo12.parser.OBO12DocumentFormat;
import org.coode.owlapi.obo12.parser.OBOConsumer;
import org.coode.owlapi.obo12.parser.OBOFrame;
import org.coode.owlapi.obo12.parser.OBOParser;
import org.coode.owlapi.obo12.parser.OBOTagValuePair;
import org.coode.owlapi.obo12.parser.ParseException;
import org.coode.owlapi.obo12.parser.RawFrameHandler;
import org.coode.owlapi.obo12.parser.Token;
import org.coode.owlapi.obo12.parser.TokenMgrError;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.UnloadableImportException;

class OWLOBO12Parser
extends AbstractOWLParser {
    private static final long serialVersionUID = 40000L;

    OWLOBO12Parser() {
    }

    private Reader reader(OWLOntologyDocumentSource source, OWLOntologyLoaderConfiguration config) throws UnsupportedEncodingException, IOException {
        if (source.isReaderAvailable()) {
            return new BufferedReader(source.getReader());
        }
        return new BufferedReader(new InputStreamReader(this.wrapInput(source, config), "UTF-8"));
    }

    private InputStream wrapInput(OWLOntologyDocumentSource source, OWLOntologyLoaderConfiguration configuration) throws IOException {
        if (source.isInputStreamAvailable()) {
            return new BufferedInputStream(source.getInputStream());
        }
        return new BufferedInputStream(this.getInputStream(source.getDocumentIRI(), configuration));
    }

    public OWLOntologyFormat parse(OWLOntologyDocumentSource source, OWLOntology ontology, OWLOntologyLoaderConfiguration config) throws OWLParserException, IOException, OWLOntologyChangeException, UnloadableImportException {
        RawFrameHandler rawFrameHandler = new RawFrameHandler();
        OBOConsumer oboConsumer = new OBOConsumer(ontology, config, source.getDocumentIRI());
        try {
            Reader r = this.reader(source, config);
            OBOParser parser = new OBOParser(r);
            parser.setHandler(rawFrameHandler);
            parser.parse();
            OWLOBO12Parser.parseFrames(rawFrameHandler, oboConsumer);
        }
        catch (ParseException e) {
            if (e.getCause() != null && e.getCause() instanceof OWLOntologyChangeException) {
                throw (OWLOntologyChangeException)e.getCause();
            }
            if (e.getCause() != null && e.getCause() instanceof OWLOntologyAlreadyExistsException) {
                OWLOntologyAlreadyExistsException ex = (OWLOntologyAlreadyExistsException)e.getCause();
                IRI importedOntologyIRI = ex.getOntologyID().getOntologyIRI();
                throw new UnloadableImportException((OWLOntologyCreationException)ex, ontology.getOWLOntologyManager().getOWLDataFactory().getOWLImportsDeclaration(importedOntologyIRI));
            }
            Token currentToken = e.currentToken;
            if (currentToken != null) {
                int beginLine = currentToken.beginLine;
                int beginColumn = currentToken.beginColumn;
                throw new OWLParserException((Throwable)((Object)e), beginLine, beginColumn);
            }
            throw new OWLParserException((Throwable)((Object)e));
        }
        catch (TokenMgrError e) {
            throw new OWLParserException((Throwable)((Object)e));
        }
        catch (OWLOntologyInputSourceException e) {
            throw new OWLParserException((Throwable)e);
        }
        catch (IOException e) {
            throw new OWLParserException((Throwable)e);
        }
        OBO12DocumentFormat format = new OBO12DocumentFormat();
        format.setIDSpaceManager(oboConsumer.getIdSpaceManager());
        return format;
    }

    private static void parseFrames(RawFrameHandler rawFrameHandler, OBOConsumer oboConsumer) {
        OWLOBO12Parser.parseHeaderFrame(rawFrameHandler, oboConsumer);
        OWLOBO12Parser.parseFrames(oboConsumer, rawFrameHandler.getTypeDefFrames());
        OWLOBO12Parser.parseFrames(oboConsumer, rawFrameHandler.getNonTypeDefFrames());
    }

    private static void parseHeaderFrame(RawFrameHandler rawFrameHandler, OBOConsumer consumer) {
        consumer.startHeader();
        OWLOBO12Parser.parseFrameTagValuePairs(consumer, rawFrameHandler.getHeaderFrame());
        consumer.endHeader();
    }

    private static void parseFrames(OBOConsumer oboConsumer, List<OBOFrame> frames) {
        for (OBOFrame frame : frames) {
            OWLOBO12Parser.parseFrame(oboConsumer, frame);
        }
    }

    private static void parseFrame(OBOConsumer oboConsumer, OBOFrame frame) {
        oboConsumer.startFrame(frame.getFrameType());
        OWLOBO12Parser.parseFrameTagValuePairs(oboConsumer, frame);
        oboConsumer.endFrame();
    }

    private static void parseFrameTagValuePairs(OBOConsumer oboConsumer, OBOFrame frame) {
        for (OBOTagValuePair tagValuePair : frame.getTagValuePairs()) {
            oboConsumer.handleTagValue(tagValuePair.getTagName(), tagValuePair.getValue(), tagValuePair.getQualifier(), tagValuePair.getComment());
        }
    }

    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology) throws OWLParserException, IOException, OWLOntologyChangeException, UnloadableImportException {
        return this.parse(documentSource, ontology, new OWLOntologyLoaderConfiguration());
    }
}

