/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.owl;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.coode.owlapi.functionalrenderer.OWLObjectRenderer;
import org.semanticweb.owlapi.formats.LabelFunctionalDocumentFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.util.AbstractOWLOntologyStorer;
import org.semanticweb.owlapi.util.DefaultPrefixManager;

public class LabelFunctionalSyntaxStorer
extends AbstractOWLOntologyStorer {
    private static final long serialVersionUID = 40000L;

    public boolean canStoreOntology(OWLOntologyFormat ontologyFormat) {
        return ontologyFormat instanceof LabelFunctionalDocumentFormat;
    }

    protected void storeOntology(OWLOntology ontology, Writer writer, OWLOntologyFormat format) throws OWLOntologyStorageException {
        try {
            OWLObjectRenderer renderer = new OWLObjectRenderer(ontology, writer);
            renderer.setPrefixManager((DefaultPrefixManager)new LabelPrefixManager(ontology));
            ontology.accept((OWLObjectVisitor)renderer);
            writer.flush();
        }
        catch (IOException e) {
            throw new OWLOntologyStorageException((Throwable)e);
        }
    }

    protected void storeOntology(OWLOntologyManager manager, OWLOntology ontology, Writer writer, OWLOntologyFormat format) throws OWLOntologyStorageException {
        this.storeOntology(ontology, writer, format);
    }

    static class LabelPrefixManager
    extends DefaultPrefixManager
    implements PrefixManager {
        private static final long serialVersionUID = 40000L;
        private final OWLOntology ontology;
        private final PrefixManager delegate;

        LabelPrefixManager(OWLOntology ontology) {
            this.ontology = ontology;
            OWLOntologyFormat ontologyFormat = ontology.getOWLOntologyManager().getOntologyFormat(ontology);
            this.delegate = ontologyFormat instanceof PrefixManager ? (PrefixManager)ontologyFormat : new DefaultPrefixManager();
        }

        public String getPrefixIRI(IRI iri) {
            for (OWLAnnotationAssertionAxiom annotation : this.ontology.getAnnotationAssertionAxioms((OWLAnnotationSubject)iri)) {
                OWLAnnotationValue value;
                if (!annotation.getProperty().isLabel() || !((value = annotation.getValue()) instanceof OWLLiteral)) continue;
                return '<' + ((OWLLiteral)value).getLiteral() + '>';
            }
            return this.delegate.getPrefixIRI(iri);
        }

        public String getDefaultPrefix() {
            return this.delegate.getDefaultPrefix();
        }

        public boolean containsPrefixMapping(String prefixName) {
            return this.delegate.containsPrefixMapping(prefixName);
        }

        public String getPrefix(String prefixName) {
            return this.delegate.getPrefix(prefixName);
        }

        public Map<String, String> getPrefixName2PrefixMap() {
            return this.delegate.getPrefixName2PrefixMap();
        }

        public IRI getIRI(String prefixIRI) {
            return this.delegate.getIRI(prefixIRI);
        }

        public Set<String> getPrefixNames() {
            return this.delegate.getPrefixNames();
        }
    }
}

