/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.oboformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import org.coode.owlapi.obo.parser.OBOOntologyFormat;
import org.obolibrary.obo2owl.OWLAPIObo2Owl;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.parser.OBOFormatParser;
import org.obolibrary.oboformat.parser.OBOFormatParserException;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParser;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.UnloadableImportException;

public class OBOFormatOWLAPIParser
implements OWLParser,
Serializable {
    private static final long serialVersionUID = 40000L;

    public OWLOntologyFormat parse(IRI documentIRI, OWLOntology ontology) throws IOException {
        try {
            OBOFormatOWLAPIParser.parse(documentIRI, null, ontology);
        }
        catch (OBOFormatParserException e) {
            throw new OWLParserException((Throwable)((Object)e));
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLParserException((Throwable)e);
        }
        return new OBOOntologyFormat();
    }

    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws IOException {
        try {
            OBOFormatOWLAPIParser.parse(null, documentSource, ontology);
        }
        catch (OBOFormatParserException e) {
            throw new OWLParserException((Throwable)((Object)e));
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLParserException((Throwable)e);
        }
        return new OBOOntologyFormat();
    }

    private static OWLOntology parse(IRI iri, OWLOntologyDocumentSource source, OWLOntology in) throws IOException, OWLOntologyCreationException {
        if (iri == null && source == null) {
            throw new IllegalArgumentException("iri and source annot both be null");
        }
        OBOFormatParser p = new OBOFormatParser();
        OBODoc obodoc = null;
        if (iri != null) {
            obodoc = p.parse(iri.toURI().toURL());
        } else if (source.isReaderAvailable()) {
            obodoc = p.parse(new BufferedReader(source.getReader()));
        } else if (source.isInputStreamAvailable()) {
            obodoc = p.parse(new BufferedReader(new InputStreamReader(source.getInputStream())));
        } else {
            return OBOFormatOWLAPIParser.parse(source.getDocumentIRI(), null, in);
        }
        OWLAPIObo2Owl bridge = new OWLAPIObo2Owl(in.getOWLOntologyManager());
        OWLOntology ontology = bridge.convert(obodoc, in);
        if (ontology == in) {
            return in;
        }
        return ontology;
    }

    public void setOWLOntologyManager(OWLOntologyManager owlOntologyManager) {
    }

    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology) throws OWLParserException, IOException, OWLOntologyChangeException, UnloadableImportException {
        return this.parse(documentSource, ontology, new OWLOntologyLoaderConfiguration());
    }
}

