/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.core;

public enum DiagramType {
    UML,
    BPM,
    DITAA,
    DOT,
    PROJECT,
    JCCKIT,
    SALT,
    FLOW,
    CREOLE,
    MATH,
    LATEX,
    DEFINITION,
    GANTT,
    CHRONOLOGY,
    NW,
    MINDMAP,
    WBS,
    WIRE,
    JSON,
    GIT,
    BOARD,
    YAML,
    HCL,
    EBNF,
    REGEX,
    FILES,
    CHEN_EER,
    UNKNOWN;


    public static DiagramType getTypeFromArobaseStart(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c != '@' && c != '\\') {
                return UNKNOWN;
            }
            int pos = i + 1;
            if (text.length() - pos < 5 || !DiagramType.check("start", text, pos)) {
                return UNKNOWN;
            }
            int p = pos + 5;
            if (p >= text.length()) {
                return UNKNOWN;
            }
            return DiagramType.getType(text, p);
        }
        return UNKNOWN;
    }

    private static DiagramType getType(String text, int p) {
        switch (Character.toLowerCase(text.charAt(p))) {
            case 'b': {
                if (DiagramType.check("bpm", text, p)) {
                    return BPM;
                }
                if (DiagramType.check("board", text, p)) {
                    return BOARD;
                }
                return UNKNOWN;
            }
            case 'c': {
                if (DiagramType.check("creole", text, p)) {
                    return CREOLE;
                }
                if (DiagramType.check("chronology", text, p)) {
                    return CHRONOLOGY;
                }
                if (DiagramType.check("chen", text, p)) {
                    return CHEN_EER;
                }
                return UNKNOWN;
            }
            case 'd': {
                if (DiagramType.check("dot", text, p)) {
                    return DOT;
                }
                if (DiagramType.check("def", text, p)) {
                    return DEFINITION;
                }
                return UNKNOWN;
            }
            case 'e': {
                if (DiagramType.check("ebnf", text, p)) {
                    return EBNF;
                }
                return UNKNOWN;
            }
            case 'f': {
                if (DiagramType.check("flow", text, p)) {
                    return FLOW;
                }
                if (DiagramType.check("files", text, p)) {
                    return FILES;
                }
                return UNKNOWN;
            }
            case 'g': {
                if (DiagramType.check("gantt", text, p)) {
                    return GANTT;
                }
                if (DiagramType.check("git", text, p)) {
                    return GIT;
                }
                return UNKNOWN;
            }
            case 'h': {
                if (DiagramType.check("hcl", text, p)) {
                    return HCL;
                }
                return UNKNOWN;
            }
            case 'j': {
                if (DiagramType.check("json", text, p)) {
                    return JSON;
                }
                return UNKNOWN;
            }
            case 'l': {
                if (DiagramType.check("latex", text, p)) {
                    return LATEX;
                }
                return UNKNOWN;
            }
            case 'm': {
                if (DiagramType.check("math", text, p)) {
                    return MATH;
                }
                if (DiagramType.check("mindmap", text, p)) {
                    return MINDMAP;
                }
                return UNKNOWN;
            }
            case 'n': {
                if (DiagramType.check("nwdiag", text, p)) {
                    return NW;
                }
                return UNKNOWN;
            }
            case 'p': {
                if (DiagramType.check("project", text, p)) {
                    return PROJECT;
                }
                return UNKNOWN;
            }
            case 'r': {
                if (DiagramType.check("regex", text, p)) {
                    return REGEX;
                }
                return UNKNOWN;
            }
            case 's': {
                if (DiagramType.check("salt", text, p)) {
                    return SALT;
                }
                return UNKNOWN;
            }
            case 'u': {
                if (DiagramType.check("uml", text, p)) {
                    return UML;
                }
                return UNKNOWN;
            }
            case 'w': {
                if (DiagramType.check("wire", text, p)) {
                    return WIRE;
                }
                if (DiagramType.check("wbs", text, p)) {
                    return WBS;
                }
                return UNKNOWN;
            }
            case 'y': {
                if (DiagramType.check("yaml", text, p)) {
                    return YAML;
                }
                return UNKNOWN;
            }
        }
        return UNKNOWN;
    }

    static boolean check(String key, String text, int p) {
        return text.regionMatches(true, p, key, 0, key.length());
    }
}

