/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassDeclaration;
import net.sourceforge.pmd.lang.java.metrics.JavaMetrics;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.metrics.Metric;
import net.sourceforge.pmd.lang.metrics.MetricsUtil;
import net.sourceforge.pmd.util.StringUtil;

public class GodClassRule
extends AbstractJavaRulechainRule {
    private static final int WMC_VERY_HIGH = 47;
    private static final int FEW_ATFD_THRESHOLD = 5;
    private static final double TCC_THRESHOLD = 0.3333333333333333;

    public GodClassRule() {
        super(ASTClassDeclaration.class, new Class[0]);
    }

    public Object visit(ASTClassDeclaration node, Object data) {
        if (!MetricsUtil.supportsAll((Node)node, (Metric[])new Metric[]{JavaMetrics.WEIGHED_METHOD_COUNT, JavaMetrics.TIGHT_CLASS_COHESION, JavaMetrics.ACCESS_TO_FOREIGN_DATA})) {
            return data;
        }
        int wmc = (Integer)MetricsUtil.computeMetric(JavaMetrics.WEIGHED_METHOD_COUNT, (Node)node);
        double tcc = (Double)MetricsUtil.computeMetric(JavaMetrics.TIGHT_CLASS_COHESION, (Node)node);
        int atfd = (Integer)MetricsUtil.computeMetric(JavaMetrics.ACCESS_TO_FOREIGN_DATA, (Node)node);
        if (wmc >= 47 && atfd > 5 && tcc < 0.3333333333333333) {
            this.asCtx(data).addViolation((Node)node, new Object[]{wmc, StringUtil.percentageString((double)tcc, (int)3), atfd});
        }
        return data;
    }
}

