/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import java.io.IOException;
import java.io.InputStream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class Loader {
    Loader() {
    }

    abstract @Nullable InputStream getInputStream() throws IOException;

    static class StreamLoader
    extends Loader {
        private final @NonNull String name;
        private final @NonNull InputStream stream;

        StreamLoader(@NonNull String name, @NonNull InputStream stream) {
            this.name = name;
            this.stream = stream;
        }

        @Override
        @NonNull InputStream getInputStream() {
            return this.stream;
        }

        public String toString() {
            return "StreamLoader(for " + this.name + ")";
        }
    }

    static class FailedLoader
    extends Loader {
        static final FailedLoader INSTANCE = new FailedLoader();

        FailedLoader() {
        }

        @Override
        @Nullable InputStream getInputStream() {
            return null;
        }

        public String toString() {
            return "(failed loader)";
        }
    }
}

