/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.matchers;

import ch.lambdaj.Lambda;
import java.util.Arrays;
import java.util.List;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestOutcomeResultsMatcher
extends TypeSafeMatcher<TestOutcome> {
    private final List<TestResult> expectedTestResults;

    public TestOutcomeResultsMatcher(TestResult ... expectedTestResults) {
        this.expectedTestResults = Arrays.asList(expectedTestResults);
    }

    public boolean matchesSafely(TestOutcome testOutcome) {
        List<TestStep> allSteps = testOutcome.getFlattenedTestSteps();
        List allTestResults = Lambda.extract(allSteps, (Object)((Object)((TestStep)Lambda.on(TestStep.class)).getResult()));
        return ((Object)allTestResults).equals(this.expectedTestResults);
    }

    public void describeTo(Description description) {
        description.appendText("a test outcome with results " + Arrays.toString(this.expectedTestResults.toArray()));
    }
}

