/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.screenshots;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.inject.Inject;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.imageio.ImageIO;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.screenshots.QueuedScreenshot;
import net.thucydides.core.screenshots.ScreenshotProcessor;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultithreadScreenshotProcessor
implements ScreenshotProcessor {
    List<Thread> screenshotThreads;
    final Queue<QueuedScreenshot> queue;
    static final int THREAD_COUNT = 5;
    private final EnvironmentVariables environmentVariables;
    private final Logger logger = LoggerFactory.getLogger(MultithreadScreenshotProcessor.class);

    @Inject
    public MultithreadScreenshotProcessor(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.queue = new ConcurrentLinkedQueue<QueuedScreenshot>();
        this.screenshotThreads = Lists.newArrayList();
        this.start();
    }

    public void start() {
        for (int i = 0; i < 5; ++i) {
            Thread screenshotThread = new Thread(new Processor(this.queue));
            this.screenshotThreads.add(screenshotThread);
            screenshotThread.start();
        }
    }

    public void waitUntilDone() {
        while (!this.queue.isEmpty()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueScreenshot(QueuedScreenshot queuedScreenshot) {
        this.queue.offer(queuedScreenshot);
        Queue<QueuedScreenshot> queue = this.queue;
        synchronized (queue) {
            this.queue.notifyAll();
        }
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Processor
    implements Runnable {
        private final Queue<QueuedScreenshot> queue;
        boolean done = false;

        Processor(Queue<QueuedScreenshot> queue) {
            this.queue = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.done) {
                this.saveQueuedScreenshot();
                Queue<QueuedScreenshot> queue = this.queue;
                synchronized (queue) {
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        private void saveQueuedScreenshot() {
            while (!this.queue.isEmpty()) {
                QueuedScreenshot queuedScreenshot = this.queue.poll();
                if (queuedScreenshot == null) continue;
                this.processScreenshot(queuedScreenshot);
            }
        }

        private void processScreenshot(QueuedScreenshot queuedScreenshot) {
            if (this.shouldResize(queuedScreenshot)) {
                this.resizeScreenshot(queuedScreenshot);
            } else {
                this.moveScreenshot(queuedScreenshot);
            }
        }

        private int getResizedWidth() {
            return MultithreadScreenshotProcessor.this.environmentVariables.getPropertyAsInteger(ThucydidesSystemProperty.RESIZED_WIDTH, (Integer)0);
        }

        private boolean shouldResize(QueuedScreenshot queuedScreenshot) {
            BufferedImage image;
            if (this.getResizedWidth() > 0 && (image = this.readImage(queuedScreenshot)) != null) {
                int width = image.getData().getWidth();
                return width != this.getResizedWidth();
            }
            return false;
        }

        private BufferedImage readImage(QueuedScreenshot queuedScreenshot) {
            BufferedImage image = null;
            try {
                image = ImageIO.read(queuedScreenshot.getSourceFile());
            }
            catch (IOException e) {
                MultithreadScreenshotProcessor.this.logger.warn("Failed to read the stored screenshot (possibly an out of memory error): " + e.getMessage());
            }
            return image;
        }

        private void moveScreenshot(QueuedScreenshot queuedScreenshot) {
            try {
                Files.move((File)queuedScreenshot.getSourceFile(), (File)queuedScreenshot.getDestinationFile());
            }
            catch (Throwable e) {
                MultithreadScreenshotProcessor.this.logger.warn("Failed to write screenshot (possibly an out of memory error): " + e.getMessage());
            }
        }

        private void resizeScreenshot(QueuedScreenshot queuedScreenshot) {
            try {
                BufferedImage image = ImageIO.read(queuedScreenshot.getSourceFile());
                int width = image.getData().getWidth();
                int height = image.getData().getHeight();
                int targetWidth = this.getResizedWidth();
                int targetHeight = (int)((double)targetWidth / (double)width * (double)height);
                BufferedImage resizedImage = this.resize(image, targetWidth, targetHeight);
                ImageIO.write((RenderedImage)resizedImage, "png", queuedScreenshot.getDestinationFile());
                queuedScreenshot.getSourceFile().delete();
            }
            catch (Throwable e) {
                MultithreadScreenshotProcessor.this.logger.warn("Failed to write screenshot (possibly an out of memory error): " + e.getMessage());
            }
        }

        private BufferedImage resize(BufferedImage image, int width, int height) {
            int type = image.getType() == 0 ? 2 : image.getType();
            BufferedImage resizedImage = new BufferedImage(width, height, type);
            Graphics2D g = resizedImage.createGraphics();
            g.setComposite(AlphaComposite.Src);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.drawImage(image, 0, 0, width, height, null);
            g.dispose();
            return resizedImage;
        }
    }
}

