/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.statistics;

import com.google.inject.Inject;
import java.util.List;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.statistics.TestStatisticsProvider;
import net.thucydides.core.statistics.With;
import net.thucydides.core.statistics.WithTagNamed;
import net.thucydides.core.statistics.WithTagTypeNamed;
import net.thucydides.core.statistics.WithTitle;
import net.thucydides.core.statistics.dao.TestOutcomeHistoryDAO;
import net.thucydides.core.statistics.model.TestRun;
import net.thucydides.core.statistics.model.TestRunTag;
import net.thucydides.core.statistics.model.TestStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateTestStatisticsProvider
implements TestStatisticsProvider {
    private final TestOutcomeHistoryDAO testOutcomeHistoryDAO;

    @Inject
    public HibernateTestStatisticsProvider(TestOutcomeHistoryDAO testOutcomeHistoryDAO) {
        this.testOutcomeHistoryDAO = testOutcomeHistoryDAO;
    }

    @Override
    public List<TestRun> testRunsForTest(With withCondition) {
        if (withCondition instanceof WithTitle) {
            return this.testOutcomeHistoryDAO.findTestRunsByTitle(((WithTitle)withCondition).getTitle());
        }
        return null;
    }

    @Override
    public List<TestRun> getAllTestHistories() {
        return this.testOutcomeHistoryDAO.findAll();
    }

    @Override
    public TestStatistics statisticsForTests(With withCondition) {
        if (withCondition instanceof WithTitle) {
            return this.testStatisticsForTitle((WithTitle)withCondition);
        }
        if (withCondition instanceof WithTagNamed) {
            return this.testStatisticsForTestsWithTag((WithTagNamed)withCondition);
        }
        if (withCondition instanceof WithTagTypeNamed) {
            return this.testStatisticsForTestsWithTagType((WithTagTypeNamed)withCondition);
        }
        return null;
    }

    private TestStatistics testStatisticsForTestsWithTag(WithTagNamed withCondition) {
        String tag = withCondition.getTag();
        Long totalTests = this.testOutcomeHistoryDAO.countTestRunsByTag(tag);
        Long passingTests = this.testOutcomeHistoryDAO.countTestRunsByTagAndResult(tag, TestResult.SUCCESS);
        Long failingTests = this.testOutcomeHistoryDAO.countTestRunsByTagAndResult(tag, TestResult.FAILURE);
        List<TestResult> results = this.testOutcomeHistoryDAO.getResultsForTestsWithTag(tag);
        List<TestRunTag> latestTags = this.testOutcomeHistoryDAO.getLatestTagsForTestsWithTag(tag);
        return new TestStatistics(totalTests, passingTests, failingTests, results, latestTags);
    }

    private TestStatistics testStatisticsForTestsWithTagType(WithTagTypeNamed withCondition) {
        String tagType = withCondition.getTagType();
        Long totalTests = this.testOutcomeHistoryDAO.countTestRunsByTagType(tagType);
        Long passingTests = this.testOutcomeHistoryDAO.countTestRunsByTagTypeAndResult(tagType, TestResult.SUCCESS);
        Long failingTests = this.testOutcomeHistoryDAO.countTestRunsByTagTypeAndResult(tagType, TestResult.FAILURE);
        List<TestResult> results = this.testOutcomeHistoryDAO.getResultsForTestsWithTagType(tagType);
        List<TestRunTag> latestTags = this.testOutcomeHistoryDAO.getLatestTagsForTestsWithTagType(tagType);
        return new TestStatistics(totalTests, passingTests, failingTests, results, latestTags);
    }

    private TestStatistics testStatisticsForTitle(WithTitle withCondition) {
        Long totalTests = this.testOutcomeHistoryDAO.countTestRunsByTitle(withCondition.getTitle());
        Long passingTests = this.testOutcomeHistoryDAO.countTestRunsByTitleAndResult(withCondition.getTitle(), TestResult.SUCCESS);
        Long failingTests = this.testOutcomeHistoryDAO.countTestRunsByTitleAndResult(withCondition.getTitle(), TestResult.FAILURE);
        List results = this.testOutcomeHistoryDAO.getResultsTestWithTitle(withCondition.getTitle());
        List<TestRunTag> latestTags = this.testOutcomeHistoryDAO.getLatestTagsForTestWithTitleByTitle(withCondition.getTitle());
        return new TestStatistics(totalTests, passingTests, failingTests, results, latestTags);
    }

    @Override
    public List<TestRunTag> findAllTags() {
        return this.testOutcomeHistoryDAO.findAllTags();
    }

    @Override
    public List<String> findAllTagTypes() {
        return this.testOutcomeHistoryDAO.findAllTagTypes();
    }
}

