/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.statistics.model;

import ch.lambdaj.Lambda;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.statistics.model.TestRunTag;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestStatistics {
    private final Long totalTestRuns;
    private final Long passingTestRuns;
    private final Long failingTestRuns;
    private final List<TestResult> testResults;
    private final List<TestRunTag> tags;
    private static final int OVERALL = Integer.MAX_VALUE;

    public TestStatistics(Long totalTestRuns, Long passingTestRuns, Long failingTestRuns, List<TestResult> testResults, List<TestRunTag> tags) {
        this.totalTestRuns = totalTestRuns;
        this.passingTestRuns = passingTestRuns;
        this.failingTestRuns = failingTestRuns;
        this.tags = ImmutableList.copyOf(tags);
        this.testResults = ImmutableList.copyOf(testResults);
    }

    public Long getTotalTestRuns() {
        return this.totalTestRuns;
    }

    public Long getPassingTestRuns() {
        return this.passingTestRuns;
    }

    public Long getFailingTestRuns() {
        return this.failingTestRuns;
    }

    public Double getOverallPassRate() {
        if (this.totalTestRuns > 0L) {
            return (double)this.passingTestRuns.longValue() / (double)this.totalTestRuns.longValue();
        }
        return 0.0;
    }

    public List<TestRunTag> getTags() {
        return this.tags;
    }

    public PassRateBuilder getPassRate() {
        return new PassRateBuilder(Integer.MAX_VALUE);
    }

    public ResultCountBuilder countResults() {
        return new ResultCountBuilder(Integer.MAX_VALUE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ResultCountBuilder {
        int testRunsOverPeriod;

        public ResultCountBuilder(int testRunsOverPeriod) {
            this.testRunsOverPeriod = testRunsOverPeriod;
        }

        public ResultCountBuilder overTheLast(int number) {
            return new ResultCountBuilder(number);
        }

        public int whereTheOutcomeWas(TestResult testResult) {
            return this.countTestRunsByResultInLast(testResult, this.testRunsOverPeriod, TestStatistics.this.testResults);
        }

        private int countTestRunsByResultInLast(TestResult testResult, int testRunCount, List<TestResult> testResults) {
            List<TestResult> eligableTestResults = this.mostRecent(testRunCount, testResults);
            List successfulTestResults = Lambda.select(eligableTestResults, (Matcher)Matchers.is((Object)((Object)testResult)));
            return successfulTestResults.size();
        }

        private List<TestResult> mostRecent(int testRunsOverPeriod, List<TestResult> testResults) {
            int eligableCount = this.eligableTestResultSize(testResults, testRunsOverPeriod);
            return testResults.subList(0, eligableCount);
        }

        private int eligableTestResultSize(List<TestResult> testResults, int testRunsOverPeriod) {
            return testRunsOverPeriod > testResults.size() ? testResults.size() : testRunsOverPeriod;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PassRateBuilder {
        int testRunsOverPeriod;

        public PassRateBuilder(int testRunsOverPeriod) {
            this.testRunsOverPeriod = testRunsOverPeriod;
        }

        public PassRateBuilder overTheLast(int number) {
            return new PassRateBuilder(number);
        }

        public double testRuns() {
            int eligableTestRunCount;
            int successfulRecentTestRuns = this.countSuccessfulTestRunsInLast(this.testRunsOverPeriod, TestStatistics.this.testResults);
            int n = eligableTestRunCount = TestStatistics.this.testResults.size() < this.testRunsOverPeriod ? TestStatistics.this.testResults.size() : this.testRunsOverPeriod;
            if (eligableTestRunCount > 0) {
                return (double)successfulRecentTestRuns * 1.0 / ((double)eligableTestRunCount * 1.0);
            }
            return 0.0;
        }

        private int countSuccessfulTestRunsInLast(int testRunCount, List<TestResult> testResults) {
            List<TestResult> eligableTestResults = this.mostRecent(testRunCount, testResults);
            List successfulTestResults = Lambda.select(eligableTestResults, (Matcher)Matchers.is((Object)((Object)TestResult.SUCCESS)));
            return successfulTestResults.size();
        }

        private List<TestResult> mostRecent(int testRunsOverPeriod, List<TestResult> testResults) {
            int eligableCount = this.eligableTestResultSize(testResults, testRunsOverPeriod);
            return testResults.subList(0, eligableCount);
        }

        private int eligableTestResultSize(List<TestResult> testResults, int testRunsOverPeriod) {
            return testRunsOverPeriod > testResults.size() ? testResults.size() : testRunsOverPeriod;
        }
    }
}

