/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.io.Serializable;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.pages.SystemClock;
import net.thucydides.core.steps.StepDelayer;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScenarioSteps
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScenarioSteps.class);
    private final Pages pages;
    private final SystemClock clock;

    public ScenarioSteps(Pages pages) {
        this.pages = pages;
        this.clock = (SystemClock)Injectors.getInjector().getInstance(SystemClock.class);
    }

    public WebDriver getDriver() {
        return this.pages.getDriver();
    }

    public Pages getPages() {
        return this.pages;
    }

    public Pages onPage() {
        return this.pages;
    }

    public Pages pages() {
        return this.getPages();
    }

    public <T extends ScenarioSteps> T onSamePage(Class<T> stepsType) {
        this.getPages().onSamePage();
        return (T)((ScenarioSteps)stepsType.cast(this));
    }

    public void waitABit(long delayInMilliseconds) {
        try {
            Thread.sleep(delayInMilliseconds);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Wait a bit method was interrupted.", (Throwable)e);
        }
    }

    public StepDelayer.WaitForBuilder waitFor(int duration) {
        return new StepDelayer(this.clock).waitFor(duration);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

