/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.jbehave;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFinder {
    private final ClassLoader classLoader;
    private List<Class<? extends Annotation>> expectedAnnotations;

    public ClassFinder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static ClassFinder loadClasses() {
        return new ClassFinder(ClassFinder.getDefaultClassLoader());
    }

    public ClassFinder withClassLoader(ClassLoader classLoader) {
        return new ClassFinder(classLoader);
    }

    public List<Class<?>> fromPackage(String packageName) {
        if (this.expectedAnnotations == null) {
            return this.allClassesInPackage(packageName);
        }
        return this.annotatedClassesInPackage(packageName);
    }

    private List<Class<?>> allClassesInPackage(String packageName) {
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = this.classResourcesOn(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList classes = Lists.newArrayList();
        for (File directory : dirs) {
            classes.addAll(this.findClasses(directory, packageName));
        }
        return classes;
    }

    public ClassFinder annotatedWith(Class<? extends Annotation> ... someAnnotations) {
        this.expectedAnnotations = ImmutableList.copyOf((Object[])someAnnotations);
        return this;
    }

    public List<Class<?>> annotatedClassesInPackage(String packageName) {
        Reflections reflections = new Reflections(new Object[]{packageName, new SubTypesScanner(), new TypeAnnotationsScanner(), new MethodAnnotationsScanner(), new ResourcesScanner(), this.getClassLoader()});
        HashSet matchingClasses = Sets.newHashSet();
        for (Class<? extends Annotation> expectedAnnotation : this.expectedAnnotations) {
            matchingClasses.addAll(reflections.getTypesAnnotatedWith(expectedAnnotation));
            matchingClasses.addAll(this.classesFrom(reflections.getMethodsAnnotatedWith(expectedAnnotation)));
        }
        return ImmutableList.copyOf((Collection)matchingClasses);
    }

    private Collection<Class<?>> classesFrom(Set<Method> annotatedMethods) {
        return Lambda.convert(annotatedMethods, this.toDeclaringCasses());
    }

    private Converter<Method, Class<?>> toDeclaringCasses() {
        return new Converter<Method, Class<?>>(){

            public Class convert(Method from) {
                return from.getDeclaringClass();
            }
        };
    }

    private Enumeration<URL> classResourcesOn(String path) {
        try {
            return this.getClassLoader().getResources(path);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not access class path at " + path, e);
        }
    }

    private List<Class<?>> findClasses(File directory, String packageName) {
        ArrayList classes = Lists.newArrayList();
        if (!directory.exists()) {
            return classes;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    classes.addAll(this.findClasses(file, packageName + "." + file.getName()));
                    continue;
                }
                if (!file.getName().endsWith(".class") || !this.isNotAnInnerClass(file.getName())) continue;
                classes.add(this.correspondingClass(packageName, file));
            }
        }
        return classes;
    }

    private Class<?> correspondingClass(String packageName, File file) {
        try {
            String fullyQualifiedClassName = packageName + '.' + this.simpleClassNameOf(file);
            return this.getClassLoader().loadClass(fullyQualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find or access class for " + file, e);
        }
    }

    private static ClassLoader getDefaultClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private String simpleClassNameOf(File file) {
        return file.getName().substring(0, file.getName().length() - 6);
    }

    private boolean isNotAnInnerClass(String className) {
        return !className.contains("$");
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

